/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;

public final class AWTChangeListenerWrapper
implements ChangeListener {
    private final ChangeListener listener;

    public AWTChangeListenerWrapper(ChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.stateChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildStateChangedRunnable(event));
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.propertyChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildPropertyChangedRunnable(event));
        }
    }

    @Override
    public void itemsAdded(CollectionAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsAddedRunnable(event));
        }
    }

    @Override
    public void itemsRemoved(CollectionRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsRemovedRunnable(event));
        }
    }

    @Override
    public void collectionCleared(CollectionClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.collectionCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildCollectionClearedRunnable(event));
        }
    }

    @Override
    public void collectionChanged(CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.collectionChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildCollectionChangedRunnable(event));
        }
    }

    @Override
    public void itemsAdded(ListAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsAddedRunnable(event));
        }
    }

    @Override
    public void itemsRemoved(ListRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsRemovedRunnable(event));
        }
    }

    @Override
    public void itemsMoved(ListMoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsMoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsMovedRunnable(event));
        }
    }

    @Override
    public void itemsReplaced(ListReplaceEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsReplaced_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsReplacedRunnable(event));
        }
    }

    @Override
    public void listCleared(ListClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildListClearedRunnable(event));
        }
    }

    @Override
    public void listChanged(ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildListChangedRunnable(event));
        }
    }

    private Runnable buildStateChangedRunnable(final StateChangeEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.stateChanged_(event);
            }
        };
    }

    private Runnable buildPropertyChangedRunnable(final PropertyChangeEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.propertyChanged_(event);
            }
        };
    }

    private Runnable buildItemsAddedRunnable(final CollectionAddEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsAdded_(event);
            }

            public String toString() {
                return "items added runnable";
            }
        };
    }

    private Runnable buildItemsRemovedRunnable(final CollectionRemoveEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsRemoved_(event);
            }

            public String toString() {
                return "items removed runnable";
            }
        };
    }

    private Runnable buildCollectionClearedRunnable(final CollectionClearEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.collectionCleared_(event);
            }

            public String toString() {
                return "collection cleared runnable";
            }
        };
    }

    private Runnable buildCollectionChangedRunnable(final CollectionChangeEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.collectionChanged_(event);
            }

            public String toString() {
                return "collection changed runnable";
            }
        };
    }

    private Runnable buildItemsAddedRunnable(final ListAddEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsAdded_(event);
            }

            public String toString() {
                return "items added runnable";
            }
        };
    }

    private Runnable buildItemsRemovedRunnable(final ListRemoveEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsRemoved_(event);
            }

            public String toString() {
                return "items removed runnable";
            }
        };
    }

    private Runnable buildItemsMovedRunnable(final ListMoveEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsMoved_(event);
            }

            public String toString() {
                return "items moved runnable";
            }
        };
    }

    private Runnable buildItemsReplacedRunnable(final ListReplaceEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.itemsReplaced_(event);
            }

            public String toString() {
                return "items replaced runnable";
            }
        };
    }

    private Runnable buildListClearedRunnable(final ListClearEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.listCleared_(event);
            }

            public String toString() {
                return "list cleared runnable";
            }
        };
    }

    private Runnable buildListChangedRunnable(final ListChangeEvent event) {
        return new Runnable(){

            @Override
            public void run() {
                AWTChangeListenerWrapper.this.listChanged_(event);
            }

            public String toString() {
                return "list changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void stateChanged_(StateChangeEvent event) {
        this.listener.stateChanged(event);
    }

    void propertyChanged_(PropertyChangeEvent event) {
        this.listener.propertyChanged(event);
    }

    void itemsAdded_(CollectionAddEvent event) {
        this.listener.itemsAdded(event);
    }

    void itemsRemoved_(CollectionRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    void collectionCleared_(CollectionClearEvent event) {
        this.listener.collectionCleared(event);
    }

    void collectionChanged_(CollectionChangeEvent event) {
        this.listener.collectionChanged(event);
    }

    void itemsAdded_(ListAddEvent event) {
        this.listener.itemsAdded(event);
    }

    void itemsRemoved_(ListRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    void itemsMoved_(ListMoveEvent event) {
        this.listener.itemsMoved(event);
    }

    void itemsReplaced_(ListReplaceEvent event) {
        this.listener.itemsReplaced(event);
    }

    void listCleared_(ListClearEvent event) {
        this.listener.listCleared(event);
    }

    void listChanged_(ListChangeEvent event) {
        this.listener.listChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }
}

