/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.jsdoc.MappingException;
import org.eclipse.wst.jsdt.jsdoc.XSLTMap;

public class Util {
    public static final String XSL_HEADER = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">";
    public static final String XSL_FOOTER = "</xsl:stylesheet>";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String BUFFER_DIR = "./webCache";
    public static final boolean VERBOSE = true;

    private static File getTempDir() {
        File tempDir = new File(BUFFER_DIR);
        if (tempDir.exists()) {
            return tempDir;
        }
        tempDir.mkdir();
        return tempDir;
    }

    public static String retrieveFromUrl(String url, boolean useCache, boolean deleteOnExit) throws IOException {
        String inputLine;
        System.gc();
        String buffFile = String.valueOf(Util.getTempDir().getAbsolutePath()) + "\\" + Util.toUniqueFileName(url);
        String text = null;
        if (useCache) {
            try {
                text = Util.fileToString(buffFile);
            }
            catch (IOException iOException) {}
            if (text != null) {
                return text;
            }
        }
        StringBuffer pageText = new StringBuffer();
        URL location = new URL(url);
        URLConnection yc = location.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            pageText.append(inputLine);
        }
        in.close();
        if (useCache) {
            System.out.println("Caching URL.. " + url);
            Util.stringToFile(pageText.toString(), buffFile, false, deleteOnExit);
        }
        return pageText.toString();
    }

    public static String toUniqueFileName(String url) {
        String temp = url.replace('/', '_');
        temp = temp.replace('\\', '_');
        temp = temp.replace(':', '_');
        temp = temp.replace('#', '_');
        temp = temp.replace('?', '_');
        temp = temp.replace('%', '_');
        temp = temp.replace('=', '_');
        temp = temp.replace('&', '_');
        temp = temp.replace(';', '_');
        temp = temp.replace('(', '_');
        temp = temp.replace(')', '_');
        temp = temp.replace('\'', '_');
        temp = temp.replace(',', '_');
        temp = temp.replace('$', '_');
        return temp;
    }

    public static String retrieveFromUrlFixEncode(String url, boolean useBuffer, boolean deleteOnExit) throws IOException {
        String encoding = "ISO-8859-1";
        String text = Util.retrieveFromUrl(url, useBuffer, deleteOnExit);
        text = text.replaceAll("UTF-8", encoding);
        text = text.replaceAll("UTF-16", encoding);
        return text;
    }

    public static String applyTranslation(String text, File translation) throws MappingException {
        XSLTMap map = new XSLTMap(translation);
        return map.applyMap(text);
    }

    public static File dataToTempFile(String data) {
        File temp = null;
        try {
            temp = File.createTempFile(String.valueOf(System.currentTimeMillis()) + "_tmp", ".tmp");
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(data);
            out.close();
        }
        catch (IOException iOException) {}
        return temp;
    }

    public static String fileToString(String fileName) throws IOException {
        System.gc();
        File file = new File(fileName);
        FileInputStream fis = new FileInputStream(file);
        BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
        StringBuffer buff = new StringBuffer();
        String line = null;
        while ((line = dis.readLine()) != null) {
            buff.append(line);
        }
        fis.close();
        dis.close();
        return buff.toString();
    }

    public static File stringToFile(String data, String fileName, boolean appendToEnd, boolean deleteOnExit) {
        File temp = null;
        System.gc();
        try {
            temp = new File(fileName);
            if (deleteOnExit) {
                temp.deleteOnExit();
            }
            FileWriter writer = new FileWriter(temp, appendToEnd);
            BufferedWriter out = new BufferedWriter(writer);
            StringTokenizer st = new StringTokenizer(data, "\n");
            String fullLine = null;
            while (st.hasMoreTokens()) {
                fullLine = st.nextToken();
                if (appendToEnd) {
                    out.write(fullLine);
                    continue;
                }
                out.write(fullLine);
            }
            out.close();
        }
        catch (IOException iOException) {}
        return temp;
    }

    public static String getBaseUrl(String url) {
        int last = url.lastIndexOf(47);
        if (last < 0) {
            return url;
        }
        return url.substring(0, last);
    }
}

