/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.PortComponentImpl;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.ServiceImplBeanImpl;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.JavaResourceFilter;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.AbstractObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaBeanSelectionWidget
extends AbstractObjectSelectionWidget
implements IObjectSelectionWidget {
    private IProject serverProject_ = null;
    private String serverComponentName_ = null;
    private Composite parent_ = null;
    private JavaResourceFilter filter_ = new JavaResourceFilter();
    private IResource initialResource_ = null;
    private Listener statusListener;
    private String INFOPOP_PBCL_PAGE = "PBCL0001";
    private Text beanClassText_;
    private String INFOPOP_PBCL_TEXT_BEAN_CLASS = "PBCL0002";
    private Button beanClassBrowseButton_;
    private String INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE = "PBCL0003";
    private Button beanResourceBrowseButton_;
    private String INFOPOP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE = "PBCL0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
        this.statusListener = statusListener;
        UIUtils uiUtils = new UIUtils(pluginId_);
        this.parent_ = parent;
        Composite group = uiUtils.createComposite(parent, 4);
        group.setToolTipText(ConsumptionUIMessages.TOOLTIP_PBCL_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, String.valueOf(pluginId_) + "." + this.INFOPOP_PBCL_PAGE);
        this.beanClassText_ = uiUtils.createText(group, ConsumptionUIMessages.LABEL_BEAN_CLASS_NAME, ConsumptionUIMessages.TOOLTIP_PBCL_TEXT_BEAN_CLASS, this.INFOPOP_PBCL_TEXT_BEAN_CLASS, 2052);
        this.beanClassText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaBeanSelectionWidget.this.handleModifyBeanClassText();
            }
        });
        this.beanClassBrowseButton_ = uiUtils.createPushButton(group, ConsumptionUIMessages.BUTTON_BROWSE_CLASSES, ConsumptionUIMessages.TOOLTIP_PBCL_BUTTON_BEAN_CLASS_BROWSE, this.INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE);
        this.beanClassBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaBeanSelectionWidget.this.handleBrowseClasses();
            }
        });
        this.beanResourceBrowseButton_ = uiUtils.createPushButton(group, ConsumptionUIMessages.BUTTON_BROWSE_FILES, ConsumptionUIMessages.TOOLTIP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE, this.INFOPOP_PBCL_BUTTON_BEAN_RESOURCE_BROWSE);
        this.beanResourceBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaBeanSelectionWidget.this.handleBrowseFiles();
            }
        });
        return this;
    }

    private void handleModifyBeanClassText() {
        this.statusListener.handleEvent(null);
        this.serverProject_ = null;
        this.serverComponentName_ = null;
    }

    private void handleBrowseClasses() {
        Shell shell = this.parent_.getShell();
        IType itype = DialogUtils.browseClassesAsIType((Shell)shell, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), (IRunnableContext)new ProgressMonitorDialog(shell));
        if (itype != null) {
            this.beanClassText_.setText(itype.getFullyQualifiedName());
            try {
                IResource res = itype.getCorrespondingResource();
                if (res != null) {
                    this.serverProject_ = res.getProject();
                    IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)res);
                    if (comp != null) {
                        this.serverComponentName_ = comp.getName();
                    }
                } else {
                    this.serverProject_ = null;
                    this.serverComponentName_ = null;
                }
            }
            catch (JavaModelException javaModelException) {
                this.serverProject_ = null;
                this.serverComponentName_ = null;
            }
        }
    }

    private void handleBrowseFiles() {
        IWorkspaceRoot topResource = ResourceUtils.getWorkspaceRoot();
        IResource resource = DialogUtils.browseResources((Shell)this.parent_.getShell(), (IResource)topResource, (IResource)this.initialResource_, (Filter)this.filter_);
        this.setBeanClass(resource);
    }

    private void setBeanClass(IResource resource) {
        IPath path;
        String basename;
        if (resource != null && resource instanceof IFile && (basename = (path = resource.getFullPath()).lastSegment()) != null && basename.length() > 0) {
            String beanClass;
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null || beanPackage.length() == 0 ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
            this.beanClassText_.setText(beanClass);
            this.serverProject_ = ResourceUtils.getProjectOf((IPath)path);
            IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
            if (comp != null) {
                this.serverComponentName_ = comp.getName();
            }
        }
    }

    private void setBeanClass(ServiceImplBeanImpl serviceImpl) {
        EObject eObject;
        if (serviceImpl != null && (eObject = serviceImpl.eContainer()) instanceof PortComponentImpl) {
            PortComponentImpl pci = (PortComponentImpl)eObject;
            String beanClass = pci.getServiceEndpointInterface();
            this.beanClassText_.setText(beanClass);
        }
    }

    private void setBeanClass(BeanLink serviceImpl) {
        EObject eObject;
        if (serviceImpl != null && (eObject = serviceImpl.eContainer()) instanceof ServiceImplBeanImpl) {
            this.setBeanClass((ServiceImplBeanImpl)eObject);
        }
    }

    @Override
    public void setInitialSelection(IStructuredSelection initialSelection) {
        if (initialSelection != null && !initialSelection.isEmpty()) {
            Object object = initialSelection.getFirstElement();
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                String fileExt = iFile.getFileExtension().toLowerCase();
                if (fileExt.equals("java") || fileExt.equals("class")) {
                    this.setBeanClass((IResource)iFile);
                }
            } else if (object instanceof ICompilationUnit) {
                this.setBeanClass(((ICompilationUnit)object).getResource());
            } else if (object instanceof ServiceImplBeanImpl) {
                this.setBeanClass((ServiceImplBeanImpl)object);
            } else if (object instanceof BeanLink) {
                this.setBeanClass((BeanLink)object);
            }
        }
    }

    @Override
    public IStructuredSelection getObjectSelection() {
        return new StructuredSelection((Object)this.beanClassText_.getText());
    }

    @Override
    public IProject getProject() {
        return this.serverProject_;
    }

    @Override
    public String getComponentName() {
        return this.serverComponentName_;
    }

    public IStatus getStatus() {
        String beanClassName = this.beanClassText_.getText().trim();
        if (beanClassName == null || beanClassName.length() <= 0) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_BEAN_CANNOT_BE_EMPTY);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateSelection(IStructuredSelection objectSelection) {
        return Status.OK_STATUS;
    }

    @Override
    public String getObjectSelectionDisplayableString() {
        return "Java bean string ";
    }
}

