/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceRange;

public class ResolvedSourceField
extends SourceField {
    private String uniqueKey;

    public ResolvedSourceField(JavaElement parent, String name, String uniqueKey) {
        super(parent, name);
        this.uniqueKey = uniqueKey;
    }

    @Override
    public String getKey() {
        return this.uniqueKey;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        super.toStringInfo(tab, buffer, info, showResolvedInfo);
        if (showResolvedInfo) {
            buffer.append(" {key=");
            buffer.append(this.uniqueKey);
            buffer.append("}");
        }
    }

    @Override
    public JavaElement unresolved() {
        SourceField handle = new SourceField(this.parent, this.name);
        handle.occurrenceCount = this.occurrenceCount;
        return handle;
    }

    @Override
    public ISourceRange getJSdocRange() throws JavaScriptModelException {
        ISourceRange defaultRange = super.getJSdocRange();
        if (defaultRange != null) {
            return defaultRange;
        }
        ISourceRange range = this.getSourceRange();
        if (range == null) {
            return null;
        }
        IBuffer buf = null;
        if (this.isBinary()) {
            buf = this.getClassFile().getBuffer();
        } else {
            IJavaScriptUnit compilationUnit = this.getJavaScriptUnit();
            if (!compilationUnit.isConsistent()) {
                return null;
            }
            buf = compilationUnit.getBuffer();
        }
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buf.getChar(start) != '/') {
            IScanner scanner = ToolFactory.createScanner(true, false, false, false);
            scanner.setSource(buf.getContents().toCharArray());
            try {
                int docOffset = -1;
                int docEnd = -1;
                int previousTerminal = -1;
                int previousOffset = -1;
                int previousEnd = -1;
                int terminal = scanner.getNextToken();
                while (scanner.getCurrentTokenEndPosition() < start) {
                    previousTerminal = terminal;
                    previousOffset = scanner.getCurrentTokenStartPosition();
                    previousEnd = scanner.getCurrentTokenEndPosition() + 1;
                    terminal = scanner.getNextToken();
                }
                switch (previousTerminal) {
                    case 1002: 
                    case 1003: {
                        docOffset = previousOffset;
                        docEnd = previousEnd;
                        terminal = scanner.getNextToken();
                        break;
                    }
                }
                if (docOffset != -1) {
                    return new SourceRange(docOffset, docEnd - docOffset + 1);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return null;
    }
}

