/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.xml;

import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.DocumentReader;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILElementWithAbstract;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.extension.UnknownExtensionElement;
import org.apache.wsil.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;

public class XMLReader
implements DocumentReader {
    protected Reader reader = null;
    protected WSILDocument wsilDocument = null;
    protected ExtensionRegistry extRegistry = null;

    protected Abstract parseAbstract(Element abstractElement, WSILElementWithAbstract wsilElement) throws WSILException {
        Abstract abs = this.wsilDocument.createAbstract();
        String lang = XMLUtil.getAttributeValue(abstractElement, "xml:lang");
        if (lang != null) {
            abs.setLang(lang);
        }
        abs.setText(XMLUtil.getText(abstractElement));
        return abs;
    }

    protected Description parseDescription(Element descriptionElement, Service service) throws WSILException {
        Description description = this.wsilDocument.createDescription();
        description.setLocation(XMLUtil.getAttributeValue(descriptionElement, "location"));
        description.setReferencedNamespace(XMLUtil.getAttributeValue(descriptionElement, "referencedNamespace"));
        Element element = XMLUtil.getFirstChild(descriptionElement);
        while (element != null) {
            if (Abstract.QNAME.equals(element)) {
                description.addAbstract(this.parseAbstract(element, description));
            } else {
                description.setExtensionElement(this.parseExtensionElement(element, description));
            }
            element = XMLUtil.getNextSibling(element);
        }
        return description;
    }

    public void parseDocument(WSILDocument wsilDocument, Reader reader) throws WSILException {
        this.reader = reader;
        this.wsilDocument = wsilDocument;
        this.extRegistry = wsilDocument.getExtensionRegistry();
        if (this.extRegistry == null) {
            throw new WSILException("WSIL document does not have a defined extension registry.");
        }
        this.parseInspection(this.parseXML(reader).getDocumentElement());
    }

    protected ExtensionElement parseExtensionElement(Element element, WSILElement wsilElement) throws WSILException {
        ExtensionElement extElement = null;
        ExtensionReader extReader = null;
        QName qname = new QName(element);
        extReader = this.extRegistry.getReader(qname.getNamespaceURI());
        extElement = extReader == null ? new UnknownExtensionElement(qname, element) : extReader.parseElement(element, wsilElement);
        return extElement;
    }

    protected void parseInspection(Element inspectionElement) throws WSILException {
        Inspection inspection = this.wsilDocument.getInspection();
        inspection.setTargetNamespace(XMLUtil.getAttributeValue(inspectionElement, "targetNamespace"));
        this.saveNS(inspectionElement, inspection);
        Element element = XMLUtil.getFirstChild(inspectionElement);
        while (element != null) {
            if (Abstract.QNAME.equals(element)) {
                inspection.addAbstract(this.parseAbstract(element, inspection));
            } else if (Link.QNAME.equals(element)) {
                inspection.addLink(this.parseLink(element, inspection));
            } else if (Service.QNAME.equals(element)) {
                inspection.addService(this.parseService(element, inspection));
            } else {
                throw new WSILException("WSIL document contains undefined element: " + element.getTagName() + ".");
            }
            element = XMLUtil.getNextSibling(element);
        }
    }

    protected Link parseLink(Element linkElement, Inspection inspection) throws WSILException {
        Link link = this.wsilDocument.createLink();
        link.setLocation(XMLUtil.getAttributeValue(linkElement, "location"));
        link.setReferencedNamespace(XMLUtil.getAttributeValue(linkElement, "referencedNamespace"));
        Element element = XMLUtil.getFirstChild(linkElement);
        while (element != null) {
            if (Abstract.QNAME.equals(element)) {
                link.addAbstract(this.parseAbstract(element, link));
            } else {
                link.setExtensionElement(this.parseExtensionElement(element, link));
            }
            element = XMLUtil.getNextSibling(element);
        }
        return link;
    }

    protected Service parseService(Element serviceElement, Inspection inspection) throws WSILException {
        Service service = this.wsilDocument.createService();
        Element element = XMLUtil.getFirstChild(serviceElement);
        while (element != null) {
            if (Abstract.QNAME.equals(element)) {
                service.addAbstract(this.parseAbstract(element, service));
            } else if (ServiceName.QNAME.equals(element)) {
                service.addServiceName(this.parseServiceName(element, service));
            } else if (Description.QNAME.equals(element)) {
                service.addDescription(this.parseDescription(element, service));
            } else {
                throw new WSILException("WSIL document contains undefined element: " + element.getTagName() + ".");
            }
            element = XMLUtil.getNextSibling(element);
        }
        return service;
    }

    protected ServiceName parseServiceName(Element nameElement, Service service) throws WSILException {
        ServiceName serviceName = this.wsilDocument.createServiceName();
        String lang = XMLUtil.getAttributeValue(nameElement, "xml:lang");
        if (lang != null) {
            serviceName.setLang(lang);
        }
        serviceName.setText(XMLUtil.getText(nameElement));
        return serviceName;
    }

    protected Document parseXML(Reader reader) throws WSILException {
        Document doc = null;
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new WSILException("Could not parse WSIL document.", e);
        }
        return doc;
    }

    protected void saveNS(Element element, Inspection inspection) {
        NamedNodeMap attrList = element.getAttributes();
        int i = 0;
        while (i < attrList.getLength()) {
            Attr attr = (Attr)attrList.item(i);
            String attrValue = attr.getValue();
            String namespaceURI = attr.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                String localName = attr.getLocalName();
                if (localName != null && localName.equals("xmlns")) {
                    inspection.addNamespace(null, attrValue);
                } else {
                    inspection.addNamespace(localName, attrValue);
                }
            }
            ++i;
        }
    }
}

