/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCustomization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCustomizationEntity;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class EclipseLinkEntityListComposite
extends Pane<EclipseLinkCustomization> {
    private ModifiableCollectionValueModel<EclipseLinkCustomizationEntity> selectedEntitiesModel;
    private PropertyValueModel<EclipseLinkCustomizationEntity> selectedEntityModel;

    public EclipseLinkEntityListComposite(Pane<? extends EclipseLinkCustomization> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedEntitiesModel = this.buildSelectedEntitiesModel();
        this.selectedEntityModel = this.buildSelectedEntityModel((CollectionValueModel<EclipseLinkCustomizationEntity>)this.selectedEntitiesModel);
    }

    private ModifiableCollectionValueModel<EclipseLinkCustomizationEntity> buildSelectedEntitiesModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<EclipseLinkCustomizationEntity> buildSelectedEntityModel(CollectionValueModel<EclipseLinkCustomizationEntity> selectedEntitiesModel) {
        return new CollectionPropertyValueModelAdapter<EclipseLinkCustomizationEntity, EclipseLinkCustomizationEntity>(selectedEntitiesModel){

            protected EclipseLinkCustomizationEntity buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (EclipseLinkCustomizationEntity)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaEclipseLinkUiMessages.CUSTOMIZATION_ENTITY_LIST_COMPOSITE_GROUP_TITLE);
    }

    protected void initializeLayout(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.selectedEntitiesModel, this.buildEntityLabelProvider(), EclipseLinkHelpContextIds.PERSISTENCE_CUSTOMIZATION);
        Hyperlink customizationHyperlink = this.addHyperlink(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_CUSTOMIZATION_TAB_CUSTOMIZER_LABEL);
        this.initializeClassChooser(container, customizationHyperlink);
    }

    private AddRemovePane.Adapter<EclipseLinkCustomizationEntity> buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter<EclipseLinkCustomizationEntity>(){

            public EclipseLinkCustomizationEntity addNewItem() {
                return EclipseLinkEntityListComposite.this.addEntity();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<EclipseLinkCustomizationEntity> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<EclipseLinkCustomizationEntity> selectedItemsModel) {
                EclipseLinkCustomizationEntity customizationEntity = (EclipseLinkCustomizationEntity)selectedItemsModel.iterator().next();
                ((EclipseLinkCustomization)EclipseLinkEntityListComposite.this.getSubject()).removeEntity(customizationEntity.getName());
            }
        };
    }

    private EclipseLinkCustomizationEntity addEntity() {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((EclipseLinkCustomization)this.getSubject()).entityExists(entityName)) {
                return ((EclipseLinkCustomization)this.getSubject()).addEntity(entityName);
            }
        }
        return null;
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((EclipseLinkCustomization)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()}), (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException ex) {
            JptJpaEclipseLinkUiPlugin.instance().logError(ex);
            return null;
        }
        dialog.setTitle(JptJpaEclipseLinkUiMessages.CUSTOMIZATION_ENTITY_LIST_COMPOSITE_DIALOG_TITLE);
        dialog.setMessage(JptJpaEclipseLinkUiMessages.CUSTOMIZATION_ENTITY_LIST_COMPOSITE_DIALOG_MESSAGE);
        return dialog.open() == 0 ? (IType)dialog.getResult()[0] : null;
    }

    private IJavaProject getJavaProject() {
        return ((EclipseLinkCustomization)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                EclipseLinkCustomizationEntity entityCustomization = (EclipseLinkCustomizationEntity)element;
                return entityCustomization.getName();
            }
        };
    }

    private ModifiablePropertyValueModel<EclipseLinkCustomizationEntity> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<EclipseLinkCustomizationEntity> buildEntitiesListHolder() {
        return new ListAspectAdapter<EclipseLinkCustomization, EclipseLinkCustomizationEntity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterable<EclipseLinkCustomizationEntity> getListIterable() {
                return ((EclipseLinkCustomization)this.subject).getEntities();
            }

            protected int size_() {
                return ((EclipseLinkCustomization)this.subject).getEntitiesSize();
            }
        };
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(PropertyValueModel<EclipseLinkCustomizationEntity> entityHolder) {
        return new TransformationPropertyValueModel<EclipseLinkCustomizationEntity, Boolean>(entityHolder){

            protected Boolean transform_(EclipseLinkCustomizationEntity value) {
                return value.entityNameIsValid();
            }
        };
    }

    private ClassChooserPane<EclipseLinkCustomizationEntity> initializeClassChooser(Composite container, Hyperlink hyperlink) {
        return new ClassChooserPane<EclipseLinkCustomizationEntity>((Pane)this, this.selectedEntityModel, this.buildPaneEnablerHolder(this.selectedEntityModel), container, hyperlink){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkCustomizationEntity, String>(this.getSubjectHolder(), new String[]{"descriptorCustomizer"}){

                    protected String buildValue_() {
                        return this.getSubjectParent().getDescriptorCustomizerOf(this.getSubjectName());
                    }

                    protected void setValue_(String value) {
                        if (value.length() == 0) {
                            value = null;
                        }
                        this.getSubjectParent().setDescriptorCustomizerOf(this.getSubjectName(), value);
                    }
                };
            }

            protected String getClassName() {
                return this.getSubjectParent().getDescriptorCustomizerOf(this.getSubjectName());
            }

            protected IJavaProject getJavaProject() {
                return this.getSubjectParent().getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                this.getSubjectParent().setDescriptorCustomizerOf(this.getSubjectName(), className);
            }

            protected String getSuperInterfaceName() {
                return "org.eclipse.persistence.config.DescriptorCustomizer";
            }

            private String getSubjectName() {
                return ((EclipseLinkCustomizationEntity)this.getSubjectHolder().getValue()).getName();
            }

            private EclipseLinkCustomization getSubjectParent() {
                return ((EclipseLinkCustomizationEntity)this.getSubjectHolder().getValue()).getParent();
            }
        };
    }
}

