/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.wst.wsi.internal.core.monitor.config.Comment;
import org.eclipse.wst.wsi.internal.core.monitor.config.Redirect;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;

public class RedirectImpl
implements Redirect {
    protected Comment comment;
    protected int listenPort;
    protected String host;
    protected String toProtocol;
    protected int toPort;
    protected String toHost;
    protected int maxConnections;
    protected int readTimeoutSeconds;

    @Override
    public Comment getComment() {
        return this.comment;
    }

    @Override
    public void setComment(Comment comment) {
        this.comment = comment;
    }

    @Override
    public int getListenPort() {
        return this.listenPort;
    }

    @Override
    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        URL url;
        this.host = host;
        try {
            url = new URL(host);
            this.toProtocol = url.getProtocol();
            this.toHost = url.getHost();
            this.toPort = url.getPort();
            if (this.toPort == -1) {
                this.toPort = this.toProtocol.equalsIgnoreCase("http") ? 80 : 80;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("The schemeAndHostPort option contains an invalid value: " + host);
        }
        if (url.getPath() != null && !url.getPath().equals("") || url.getQuery() != null && !url.getQuery().equals("")) {
            throw new IllegalArgumentException("The schemeAndHostPort option must contain only a scheme, host and port: " + host);
        }
    }

    @Override
    public int getToPort() {
        return this.toPort;
    }

    @Override
    public String getToHost() {
        return this.toHost;
    }

    @Override
    public String getToProtocol() {
        return this.toProtocol;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    @Override
    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("    comment ................... " + this.comment);
        pw.println("    listenPort ................ " + this.listenPort);
        pw.println("    host ...................... " + this.cutHost(this.host));
        pw.println("    maxConnections ............ " + this.maxConnections);
        pw.println("    readTimeoutSeconds ........ " + this.readTimeoutSeconds);
        return sw.toString();
    }

    private String cutHost(String host) {
        try {
            URL url = new URL(host);
            String port = url.getPort() > -1 ? String.valueOf(url.getPort()) : "80";
            return String.valueOf(url.getProtocol()) + "://" + url.getHost() + ":" + port;
        }
        catch (Exception exception) {
            return host;
        }
    }

    @Override
    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("        <" + nsName + "redirect" + ">");
        if (this.comment != null) {
            pw.println(this.comment.toXMLString(nsName));
        }
        pw.print("          <" + nsName + "listenPort" + ">");
        pw.print(this.getListenPort());
        pw.println("</" + nsName + "listenPort" + ">");
        pw.print("          <" + nsName + "schemeAndHostPort" + ">");
        pw.print(XMLUtils.xmlEscapedString(this.getHost()));
        pw.println("</" + nsName + "schemeAndHostPort" + ">");
        pw.print("          <" + nsName + "maxConnections" + ">");
        pw.print(this.getMaxConnections());
        pw.println("</" + nsName + "maxConnections" + ">");
        pw.print("          <" + nsName + "readTimeoutSeconds" + ">");
        pw.print(this.getReadTimeoutSeconds());
        pw.println("</" + nsName + "readTimeoutSeconds" + ">");
        pw.println("        </" + nsName + "redirect" + ">");
        return sw.toString();
    }
}

