/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.filters.CustomFiltersDialog;
import org.eclipse.wst.jsdt.internal.ui.filters.FilterDescriptor;
import org.eclipse.wst.jsdt.internal.ui.filters.FilterMessages;
import org.eclipse.wst.jsdt.internal.ui.filters.NamePatternFilter;

public class CustomFiltersActionGroup
extends ActionGroup {
    private static final String TAG_DUMMY_TO_TEST_EXISTENCE = "TAG_DUMMY_TO_TEST_EXISTENCE";
    private static final String TAG_CUSTOM_FILTERS = "customFilters";
    private static final String TAG_USER_DEFINED_PATTERNS_ENABLED = "userDefinedPatternsEnabled";
    private static final String TAG_USER_DEFINED_PATTERNS = "userDefinedPatterns";
    private static final String TAG_XML_DEFINED_FILTERS = "xmlDefinedFilters";
    private static final String TAG_LRU_FILTERS = "lastRecentlyUsedFilters";
    private static final String TAG_CHILD = "child";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_FILTER_ID = "filterId";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String SEPARATOR = ",";
    private static final int MAX_FILTER_MENU_ENTRIES = 3;
    private static final String RECENT_FILTERS_GROUP_NAME = "recentFiltersGroup";
    private final StructuredViewer fViewer;
    private final NamePatternFilter fPatternFilter;
    private boolean fUserDefinedPatternsEnabled;
    private String[] fUserDefinedPatterns;
    private String[] fPreviousPatterns;
    private final Map fFilterItems;
    private Stack fLRUFilterIdsStack;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private String[] fFilterIdsUsedInLastViewMenu;
    private final String fTargetId;

    public CustomFiltersActionGroup(IViewPart part, StructuredViewer viewer) {
        this(part.getViewSite().getId(), viewer);
    }

    public CustomFiltersActionGroup(String ownerId, StructuredViewer viewer) {
        Assert.isNotNull((Object)ownerId);
        Assert.isNotNull((Object)viewer);
        this.fTargetId = ownerId;
        this.fViewer = viewer;
        this.fPatternFilter = new NamePatternFilter();
        this.fLRUFilterIdsStack = new Stack();
        this.fUserDefinedPatterns = new String[0];
        this.fUserDefinedPatternsEnabled = false;
        this.fPreviousPatterns = new String[0];
        this.fFilterItems = new HashMap();
        FilterDescriptor[] filterDescriptors = FilterDescriptor.getFilterDescriptors(this.fTargetId);
        int i = 0;
        while (i < filterDescriptors.length) {
            FilterItem item = new FilterItem(filterDescriptors[i]);
            FilterItem existing = this.fFilterItems.put(item.id, item);
            if (existing != null) {
                JavaScriptPlugin.logErrorMessage("WARNING: Duplicate id for extension-point \"org.eclipse.wst.jsdt.ui.javaElementFilters\" in " + ownerId);
            }
            ++i;
        }
        this.initializeWithViewDefaults();
        this.updateViewerFilters();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    public String[] internalGetEnabledFilterIds() {
        ArrayList<String> enabledFilterIds = new ArrayList<String>();
        for (FilterItem item : this.fFilterItems.values()) {
            if (!item.enabled) continue;
            enabledFilterIds.add(item.id);
        }
        return enabledFilterIds.toArray(new String[enabledFilterIds.size()]);
    }

    public String[] removeFiltersFor(Object parent, Object element, IContentProvider contentProvider) {
        ArrayList<String> newFilters = new ArrayList<String>();
        for (FilterItem item : this.fFilterItems.values()) {
            ViewerFilter filter;
            if (!item.enabled || (filter = item.getFilterInstance()) == null || !this.isSelected(parent, element, contentProvider, filter)) continue;
            newFilters.add(item.id);
        }
        return newFilters.toArray(new String[newFilters.size()]);
    }

    public void setFilters(String[] newFilters) {
        this.setEnabledFilterIds(newFilters);
        this.updateViewerFilters();
    }

    private boolean isSelected(Object parent, Object element, IContentProvider contentProvider, ViewerFilter filter) {
        if (contentProvider instanceof ITreeContentProvider) {
            ITreeContentProvider provider = (ITreeContentProvider)contentProvider;
            while (element != null && !(element instanceof IJavaScriptModel)) {
                if (!filter.select((Viewer)this.fViewer, parent, element)) {
                    return false;
                }
                element = provider.getParent(element);
            }
            return true;
        }
        return filter.select((Viewer)this.fViewer, parent, element);
    }

    private void setFilter(String filterId, boolean state) {
        this.fLRUFilterIdsStack.remove(filterId);
        this.fLRUFilterIdsStack.add(0, filterId);
        FilterItem item = (FilterItem)this.fFilterItems.get(filterId);
        if (item != null) {
            item.enabled = state;
            this.storeViewDefaults();
            this.updateViewerFilters();
        }
    }

    private void setEnabledFilterIds(String[] enabledIds) {
        for (FilterItem item : this.fFilterItems.values()) {
            item.enabled = false;
        }
        int i = 0;
        while (i < enabledIds.length) {
            FilterItem item;
            item = (FilterItem)this.fFilterItems.get(enabledIds[i]);
            if (item != null) {
                item.enabled = true;
            }
            ++i;
        }
    }

    private void setUserDefinedPatterns(String[] patterns) {
        this.fUserDefinedPatterns = patterns;
    }

    private void setRecentlyChangedFilters(Stack changeHistory) {
        Stack<String> oldestFirstStack = new Stack<String>();
        int length = Math.min(changeHistory.size(), 3);
        int i = 0;
        while (i < length) {
            oldestFirstStack.push(((FilterDescriptor)changeHistory.pop()).getId());
            ++i;
        }
        length = Math.min(this.fLRUFilterIdsStack.size(), 3 - oldestFirstStack.size());
        int NEWEST = 0;
        int i2 = 0;
        while (i2 < length) {
            Object filter = this.fLRUFilterIdsStack.remove(NEWEST);
            if (!oldestFirstStack.contains(filter)) {
                oldestFirstStack.push((String)filter);
            }
            ++i2;
        }
        this.fLRUFilterIdsStack = oldestFirstStack;
    }

    private boolean areUserDefinedPatternsEnabled() {
        return this.fUserDefinedPatternsEnabled;
    }

    private void setUserDefinedPatternsEnabled(boolean state) {
        this.fUserDefinedPatternsEnabled = state;
    }

    private void fillToolBar(IToolBarManager tooBar) {
    }

    public void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator("filters"));
        viewMenu.add((IContributionItem)new GroupMarker(RECENT_FILTERS_GROUP_NAME));
        viewMenu.add((IAction)new ShowFilterDialogAction());
        this.fMenuManager = viewMenu;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CustomFiltersActionGroup.this.removePreviousLRUFilterActions(manager);
                CustomFiltersActionGroup.this.addLRUFilterActions(manager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUFilterActions(IMenuManager mm) {
        if (this.fFilterIdsUsedInLastViewMenu == null) {
            return;
        }
        int i = 0;
        while (i < this.fFilterIdsUsedInLastViewMenu.length) {
            mm.remove(this.fFilterIdsUsedInLastViewMenu[i]);
            ++i;
        }
    }

    private void addLRUFilterActions(IMenuManager mm) {
        if (this.fLRUFilterIdsStack.isEmpty()) {
            this.fFilterIdsUsedInLastViewMenu = null;
            return;
        }
        TreeSet sortedFilters = new TreeSet(this.fLRUFilterIdsStack);
        String[] recentlyChangedFilterIds = sortedFilters.toArray(new String[sortedFilters.size()]);
        this.fFilterIdsUsedInLastViewMenu = new String[recentlyChangedFilterIds.length];
        int i = 0;
        while (i < recentlyChangedFilterIds.length) {
            String id;
            this.fFilterIdsUsedInLastViewMenu[i] = id = recentlyChangedFilterIds[i];
            FilterItem filterItem = (FilterItem)this.fFilterItems.get(id);
            if (filterItem != null) {
                FilterActionMenuContributionItem item = new FilterActionMenuContributionItem(this, id, filterItem.descriptor.getName(), filterItem.enabled, i + 1);
                mm.insertBefore(RECENT_FILTERS_GROUP_NAME, (IContributionItem)item);
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        this.fFilterItems.clear();
        super.dispose();
    }

    private boolean updateViewerFilters() {
        ViewerFilter[] installedFilters = this.fViewer.getFilters();
        ArrayList<ViewerFilter> viewerFilters = new ArrayList<ViewerFilter>(Arrays.asList(installedFilters));
        HashSet<String> patterns = new HashSet<String>();
        boolean hasChange = false;
        boolean patternChange = false;
        for (FilterItem item : this.fFilterItems.values()) {
            if (item.descriptor.isCustomFilter()) {
                ViewerFilter filter;
                if (item.enabled != item.previouslyEnabled && (filter = item.getFilterInstance()) != null) {
                    if (item.enabled) {
                        viewerFilters.add(filter);
                    } else {
                        viewerFilters.remove(filter);
                    }
                    hasChange = true;
                }
            } else if (item.descriptor.isPatternFilter()) {
                if (item.enabled) {
                    patterns.add(item.descriptor.getPattern());
                }
                patternChange |= item.enabled ^ item.previouslyEnabled;
            }
            item.previouslyEnabled = item.enabled;
        }
        if (this.areUserDefinedPatternsEnabled()) {
            int i = 0;
            while (i < this.fUserDefinedPatterns.length) {
                patterns.add(this.fUserDefinedPatterns[i]);
                ++i;
            }
        }
        if (!patternChange) {
            patternChange = this.hasChanges(patterns, this.fPreviousPatterns);
        }
        this.fPreviousPatterns = patterns.toArray(new String[patterns.size()]);
        if (patternChange) {
            this.fPatternFilter.setPatterns(this.fPreviousPatterns);
            if (patterns.isEmpty()) {
                viewerFilters.remove((Object)this.fPatternFilter);
            } else if (!viewerFilters.contains((Object)this.fPatternFilter)) {
                viewerFilters.add(this.fPatternFilter);
            }
            hasChange = true;
        }
        if (hasChange) {
            this.fViewer.setFilters(viewerFilters.toArray(new ViewerFilter[viewerFilters.size()]));
        }
        return hasChange;
    }

    private boolean hasChanges(HashSet patterns, String[] oldPatterns) {
        HashSet copy = (HashSet)patterns.clone();
        int i = 0;
        while (i < oldPatterns.length) {
            boolean found = copy.remove(oldPatterns[i]);
            if (!found) {
                return true;
            }
            ++i;
        }
        return !copy.isEmpty();
    }

    private void initializeWithViewDefaults() {
        String id;
        IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
        if (!store.contains(this.getPreferenceKey(TAG_DUMMY_TO_TEST_EXISTENCE))) {
            return;
        }
        this.fUserDefinedPatternsEnabled = store.getBoolean(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED));
        this.setUserDefinedPatterns(CustomFiltersDialog.convertFromString(store.getString(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS)), SEPARATOR));
        for (FilterItem item : this.fFilterItems.values()) {
            id = item.id;
            store.setDefault(id, item.descriptor.isEnabled());
            item.enabled = store.getBoolean(id);
        }
        this.fLRUFilterIdsStack.clear();
        String lruFilterIds = store.getString(TAG_LRU_FILTERS);
        StringTokenizer tokenizer = new StringTokenizer(lruFilterIds, SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            id = tokenizer.nextToken();
            if (!this.fFilterItems.containsKey(id) || this.fLRUFilterIdsStack.contains(id)) continue;
            this.fLRUFilterIdsStack.push(id);
        }
    }

    private void storeViewDefaults() {
        IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
        store.setValue(this.getPreferenceKey(TAG_DUMMY_TO_TEST_EXISTENCE), "storedViewPreferences");
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS_ENABLED), this.fUserDefinedPatternsEnabled);
        store.setValue(this.getPreferenceKey(TAG_USER_DEFINED_PATTERNS), CustomFiltersDialog.convertToString(this.fUserDefinedPatterns, SEPARATOR));
        for (FilterItem item : this.fFilterItems.values()) {
            store.setValue(item.id, item.enabled);
        }
        StringBuffer buf = new StringBuffer(this.fLRUFilterIdsStack.size() * 20);
        Iterator iter = this.fLRUFilterIdsStack.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            buf.append(SEPARATOR);
        }
        store.setValue(TAG_LRU_FILTERS, buf.toString());
    }

    private String getPreferenceKey(String tag) {
        return "CustomFiltersActionGroup." + this.fTargetId + '.' + tag;
    }

    public void saveState(IMemento memento) {
        IMemento customFilters = memento.createChild(TAG_CUSTOM_FILTERS);
        customFilters.putString(TAG_USER_DEFINED_PATTERNS_ENABLED, Boolean.toString(this.fUserDefinedPatternsEnabled));
        this.saveUserDefinedPatterns(customFilters);
        this.saveXmlDefinedFilters(customFilters);
        this.saveLRUFilters(customFilters);
    }

    private void saveXmlDefinedFilters(IMemento memento) {
        IMemento xmlDefinedFilters = memento.createChild(TAG_XML_DEFINED_FILTERS);
        for (FilterItem item : this.fFilterItems.values()) {
            IMemento child = xmlDefinedFilters.createChild(TAG_CHILD);
            child.putString(TAG_FILTER_ID, item.id);
            child.putString(TAG_IS_ENABLED, String.valueOf(item.enabled));
        }
    }

    private void saveLRUFilters(IMemento memento) {
        if (this.fLRUFilterIdsStack != null && !this.fLRUFilterIdsStack.isEmpty()) {
            IMemento lruFilters = memento.createChild(TAG_LRU_FILTERS);
            for (String id : this.fLRUFilterIdsStack) {
                IMemento child = lruFilters.createChild(TAG_CHILD);
                child.putString(TAG_FILTER_ID, id);
            }
        }
    }

    private void saveUserDefinedPatterns(IMemento memento) {
        if (this.fUserDefinedPatterns != null && this.fUserDefinedPatterns.length > 0) {
            IMemento userDefinedPatterns = memento.createChild(TAG_USER_DEFINED_PATTERNS);
            int i = 0;
            while (i < this.fUserDefinedPatterns.length) {
                IMemento child = userDefinedPatterns.createChild(TAG_CHILD);
                child.putString(TAG_PATTERN, this.fUserDefinedPatterns[i]);
                ++i;
            }
        }
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento customFilters = memento.getChild(TAG_CUSTOM_FILTERS);
        if (customFilters == null) {
            return;
        }
        String userDefinedPatternsEnabled = customFilters.getString(TAG_USER_DEFINED_PATTERNS_ENABLED);
        if (userDefinedPatternsEnabled == null) {
            return;
        }
        this.fUserDefinedPatternsEnabled = Boolean.valueOf(userDefinedPatternsEnabled);
        this.restoreUserDefinedPatterns(customFilters);
        this.restoreXmlDefinedFilters(customFilters);
        this.restoreLRUFilters(customFilters);
        this.updateViewerFilters();
    }

    private void restoreUserDefinedPatterns(IMemento memento) {
        IMemento userDefinedPatterns = memento.getChild(TAG_USER_DEFINED_PATTERNS);
        if (userDefinedPatterns != null) {
            IMemento[] children = userDefinedPatterns.getChildren(TAG_CHILD);
            String[] patterns = new String[children.length];
            int i = 0;
            while (i < children.length) {
                patterns[i] = children[i].getString(TAG_PATTERN);
                ++i;
            }
            this.setUserDefinedPatterns(patterns);
        } else {
            this.setUserDefinedPatterns(new String[0]);
        }
    }

    private void restoreXmlDefinedFilters(IMemento memento) {
        IMemento xmlDefinedFilters = memento.getChild(TAG_XML_DEFINED_FILTERS);
        if (xmlDefinedFilters != null) {
            IMemento[] children = xmlDefinedFilters.getChildren(TAG_CHILD);
            int i = 0;
            while (i < children.length) {
                String id = children[i].getString(TAG_FILTER_ID);
                Boolean isEnabled = Boolean.valueOf(children[i].getString(TAG_IS_ENABLED));
                FilterItem item = (FilterItem)this.fFilterItems.get(id);
                if (item != null) {
                    item.enabled = isEnabled;
                }
                ++i;
            }
        }
    }

    private void restoreLRUFilters(IMemento memento) {
        IMemento lruFilters = memento.getChild(TAG_LRU_FILTERS);
        this.fLRUFilterIdsStack.clear();
        if (lruFilters != null) {
            IMemento[] children = lruFilters.getChildren(TAG_CHILD);
            int i = 0;
            while (i < children.length) {
                String id = children[i].getString(TAG_FILTER_ID);
                if (this.fFilterItems.containsKey(id) && !this.fLRUFilterIdsStack.contains(id)) {
                    this.fLRUFilterIdsStack.push(id);
                }
                ++i;
            }
        }
    }

    private void openDialog() {
        CustomFiltersDialog dialog = new CustomFiltersDialog(this.fViewer.getControl().getShell(), this.fTargetId, this.areUserDefinedPatternsEnabled(), this.fUserDefinedPatterns, this.internalGetEnabledFilterIds());
        if (dialog.open() == 0) {
            this.setEnabledFilterIds(dialog.getEnabledFilterIds());
            this.setUserDefinedPatternsEnabled(dialog.areUserDefinedPatternsEnabled());
            this.setUserDefinedPatterns(dialog.getUserDefinedPatterns());
            this.setRecentlyChangedFilters(dialog.getFilterDescriptorChangeHistory());
            this.storeViewDefaults();
            this.updateViewerFilters();
        }
    }

    class FilterActionMenuContributionItem
    extends ContributionItem {
        private int fItemNumber;
        private boolean fState;
        private String fFilterId;
        private String fFilterName;
        private CustomFiltersActionGroup fActionGroup;

        public FilterActionMenuContributionItem(CustomFiltersActionGroup actionGroup, String filterId, String filterName, boolean state, int itemNumber) {
            super(filterId);
            Assert.isNotNull((Object)((Object)actionGroup));
            Assert.isNotNull((Object)filterId);
            Assert.isNotNull((Object)filterName);
            this.fActionGroup = actionGroup;
            this.fFilterId = filterId;
            this.fFilterName = filterName;
            this.fState = state;
            this.fItemNumber = itemNumber;
        }

        public void fill(Menu menu, int index) {
            MenuItem mi = new MenuItem(menu, 32, index);
            mi.setText("&" + this.fItemNumber + " " + this.fFilterName);
            mi.setSelection(this.fState);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterActionMenuContributionItem.this.fState = !FilterActionMenuContributionItem.this.fState;
                    FilterActionMenuContributionItem.this.fActionGroup.setFilter(FilterActionMenuContributionItem.this.fFilterId, FilterActionMenuContributionItem.this.fState);
                }
            });
        }

        public boolean isDynamic() {
            return true;
        }
    }

    private static class FilterItem {
        boolean enabled;
        boolean previouslyEnabled;
        FilterDescriptor descriptor;
        String id;
        private ViewerFilter filterInstance = null;

        public FilterItem(FilterDescriptor descriptor) {
            this.descriptor = descriptor;
            this.id = descriptor.getId();
            this.previouslyEnabled = false;
            this.enabled = descriptor.isEnabled();
        }

        public ViewerFilter getFilterInstance() {
            if (this.filterInstance == null) {
                this.filterInstance = this.descriptor.createViewerFilter();
            }
            return this.filterInstance;
        }
    }

    class ShowFilterDialogAction
    extends Action {
        ShowFilterDialogAction() {
            this.setText(FilterMessages.OpenCustomFiltersDialogAction_text);
            this.setImageDescriptor(JavaPluginImages.DESC_ELCL_FILTER);
            this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_FILTER);
        }

        public void run() {
            CustomFiltersActionGroup.this.openDialog();
        }
    }
}

