/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JaxbPreferences {
    private static final String JAXB_PLATFORM_NODE = "platform";
    private static final String JAXB_PLATFORM_ID = "platform-id";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String SCHEMA_NODE_PREFIX = "schema-";
    private static final String SCHEMA_LOCATION = "location";
    private static final String CLASS_GEN_NODE = "classgen";
    private static final String PACKAGE = "package";

    public static String getJaxbPlatformID(IProject project) {
        return JaxbPreferences.getJaxbPlatformID(project, "generic_2_2");
    }

    private static String getJaxbPlatformID(IProject project, String def) {
        Preferences prefs = JaxbPreferences.getJaxbPlatformPreferences(project);
        return prefs == null ? def : prefs.get(JAXB_PLATFORM_ID, def);
    }

    public static void setJaxbPlatformID(IProject project, String jaxbPlatformID) {
        Preferences prefs = JaxbPreferences.getJaxbPlatformPreferences(project);
        if (prefs != null) {
            prefs.put(JAXB_PLATFORM_ID, jaxbPlatformID);
            JaxbPreferences.flushPreferences(prefs);
        }
    }

    private static Preferences getJaxbPlatformPreferences(IProject project) {
        Preferences prefs = JaxbPreferences.getPreferences(project);
        return prefs == null ? null : prefs.node(JAXB_PLATFORM_NODE);
    }

    public static List<String> getSchemaLocations(IProject project) {
        return JaxbPreferences.getSchemaLocations(project, Collections.emptyList());
    }

    private static List<String> getSchemaLocations(IProject project, List<String> def) {
        Preferences prefs = JaxbPreferences.getSchemasPreferences(project);
        if (prefs == null) {
            return def;
        }
        try {
            ArrayList<String> schemaLocations = new ArrayList<String>();
            int i = 1;
            String nodeName = null;
            while (prefs.nodeExists(nodeName = JaxbPreferences.buildSchemaNodeName(i))) {
                Preferences schemaPrefs = prefs.node(nodeName);
                String location = schemaPrefs.get(SCHEMA_LOCATION, null);
                if (location != null) {
                    schemaLocations.add(location);
                }
                ++i;
            }
            return schemaLocations;
        }
        catch (BackingStoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return def;
        }
    }

    public static void setSchemaLocations(IProject project, List<String> schemaLocations) {
        Preferences prefs = JaxbPreferences.getSchemasPreferences(project);
        if (prefs == null) {
            return;
        }
        try {
            int i = 1;
            String nodeName = null;
            for (String location : schemaLocations) {
                nodeName = JaxbPreferences.buildSchemaNodeName(i);
                Preferences schemaPref = prefs.node(nodeName);
                schemaPref.put(SCHEMA_LOCATION, location);
                ++i;
            }
            while (prefs.nodeExists(nodeName = JaxbPreferences.buildSchemaNodeName(i))) {
                prefs.node(nodeName).removeNode();
                ++i;
            }
            JaxbPreferences.flushPreferences(prefs);
        }
        catch (BackingStoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
        }
    }

    private static Preferences getSchemasPreferences(IProject project) {
        Preferences prefs = JaxbPreferences.getPreferences(project);
        return prefs == null ? null : prefs.node(SCHEMAS_NODE);
    }

    private static String buildSchemaNodeName(int i) {
        return SCHEMA_NODE_PREFIX + String.valueOf(i);
    }

    public static String getClassGenPackage(IProject project) {
        return JaxbPreferences.getClassGenPackage(project, "");
    }

    private static String getClassGenPackage(IProject project, String def) {
        Preferences prefs = JaxbPreferences.getClassGenPreferences(project);
        return prefs == null ? def : prefs.get(PACKAGE, def);
    }

    public static void setClassGenPackage(IProject project, String packageName) {
        Preferences prefs = JaxbPreferences.getClassGenPreferences(project);
        if (prefs != null) {
            prefs.put(PACKAGE, packageName);
            JaxbPreferences.flushPreferences(prefs);
        }
    }

    private static Preferences getClassGenPreferences(IProject project) {
        Preferences prefs = JaxbPreferences.getPreferences(project);
        return prefs == null ? null : prefs.node(CLASS_GEN_NODE);
    }

    private static void flushPreferences(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
        }
    }

    private static Preferences getPreferences(IProject project) {
        IFacetedProject facetedProject = JaxbPreferences.getFacetedProject(project);
        try {
            return facetedProject == null ? null : facetedProject.getPreferences(JaxbProject.FACET);
        }
        catch (BackingStoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private static IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException ex) {
            JptJaxbCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private JaxbPreferences() {
        throw new UnsupportedOperationException();
    }
}

