/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IMonitoredServerPort;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.BaseLabelProvider;

public class MonitorLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    protected IServer server;

    public MonitorLabelProvider(IServer server) {
        this.server = server;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IMonitoredServerPort port = (IMonitoredServerPort)element;
        if (columnIndex == 0) {
            if (port.isStarted()) {
                return ImageResource.getImage("monitorOn");
            }
            return ImageResource.getImage("monitorOff");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IMonitoredServerPort port = (IMonitoredServerPort)element;
        if (columnIndex == 0) {
            if (port.isStarted()) {
                return Messages.started;
            }
            return Messages.stopped;
        }
        if (columnIndex == 1) {
            return this.notNull(port.getServerPort().getName());
        }
        if (columnIndex == 2) {
            return "" + port.getServerPort().getPort();
        }
        if (columnIndex == 3) {
            return "" + port.getMonitorPort();
        }
        String[] content = port.getContentTypes();
        if (content == null || content.length == 0) {
            return Messages.dialogMonitorContentTypeAll;
        }
        StringBuffer sb = new StringBuffer();
        int size = content.length;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(MonitorLabelProvider.getContentTypeString(content[i]));
            ++i;
        }
        return sb.toString();
    }

    protected static String getContentTypeString(String s) {
        if ("web".equals(s)) {
            return Messages.dialogMonitorContentTypeWeb;
        }
        if ("webservices".equals(s)) {
            return Messages.dialogMonitorContentTypeWebServices;
        }
        return s;
    }
}

