/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

public abstract class ListCurator<S extends Model, E>
extends AspectAdapter<S, List<E>>
implements ListValueModel<E> {
    private final ArrayList<E> record = new ArrayList();
    private final StateChangeListener stateChangeListener = this.buildStateChangeListener();

    protected ListCurator(S subject) {
        this((PropertyValueModel<S>)new StaticPropertyValueModel<S>(subject));
    }

    protected ListCurator(PropertyValueModel<? extends S> subjectModel) {
        super(subjectModel);
    }

    protected StateChangeListener buildStateChangeListener() {
        return new SubjectStateChangeListener();
    }

    @Override
    public ListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return IteratorTools.readOnly(this.record.listIterator());
    }

    @Override
    public E get(int index) {
        return this.record.get(index);
    }

    @Override
    public int size() {
        return this.record.size();
    }

    @Override
    public Object[] toArray() {
        return this.record.toArray();
    }

    @Override
    protected List<E> getAspectValue() {
        return this.record;
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChanged(List<E> oldValue, List<E> newValue) {
        this.fireListChanged("list values", this.record);
    }

    @Override
    protected void engageSubject_() {
        ((Model)this.subject).addStateChangeListener(this.stateChangeListener);
        CollectionTools.addAll(this.record, this.iteratorForRecord());
    }

    @Override
    protected void disengageSubject_() {
        ((Model)this.subject).removeStateChangeListener(this.stateChangeListener);
        this.record.clear();
    }

    protected abstract Iterator<E> iteratorForRecord();

    void submitInventoryReport() {
        ArrayList<E> newRecord = ListTools.arrayList(this.iteratorForRecord());
        int recordIndex = 0;
        for (Object newItem : newRecord) {
            this.inventoryNewItem(recordIndex, newItem);
            ++recordIndex;
        }
        recordIndex = 0;
        while (recordIndex < this.record.size()) {
            E item = this.record.get(recordIndex);
            if (newRecord.contains(item)) {
                ++recordIndex;
                continue;
            }
            this.removeItemFromInventory(recordIndex, item);
        }
    }

    private void inventoryNewItem(int recordIndex, E newItem) {
        ArrayList<E> rec = new ArrayList<E>(this.record);
        if (recordIndex < rec.size() && rec.get(recordIndex).equals(newItem)) {
            return;
        }
        if (rec.contains(newItem)) {
            this.removeItemFromInventory(recordIndex, rec.get(recordIndex));
            this.inventoryNewItem(recordIndex, newItem);
        } else {
            this.addItemToInventory(recordIndex, newItem);
        }
    }

    private void addItemToInventory(int index, E item) {
        this.addItemToList(index, item, this.record, "list values");
    }

    private void removeItemFromInventory(int index, E item) {
        this.removeItemFromList(index, this.record, "list values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.record);
    }

    protected class SubjectStateChangeListener
    extends StateChangeAdapter {
        protected SubjectStateChangeListener() {
        }

        @Override
        public void stateChanged(StateChangeEvent event) {
            ListCurator.this.submitInventoryReport();
        }
    }
}

