/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.list;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.list.CounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.list.HTMLListInfoHelper;
import org.eclipse.jst.pagedesigner.css2.list.ICounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.list.IncrementObject;
import org.eclipse.jst.pagedesigner.css2.list.ResetObject;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;

public final class CounterHelper {
    public static final int LIST_T_IMAGE = 0;
    public static final int LIST_T_DISC = 1;
    public static final int LIST_T_CIRCLE = 2;
    public static final int LIST_T_SQUARE = 3;
    public static final int LIST_T_DECIMAL = 17;
    public static final int LIST_T_DECIMAL_LEADING_ZERO = 18;
    public static final int LIST_T_LOWER_ALPHA = 19;
    public static final int LIST_T_LOWER_ROMAN = 20;
    public static final int LIST_T_UPPER_ALPHA = 21;
    public static final int LIST_T_UPPER_ROMAN = 22;
    public static final int LIST_T_LOWER_GREEK = 33;
    public static final int LIST_T_ARMENIAN = 34;
    public static final int LIST_T_GEORGIAN = 35;
    public static final int LIST_T_NONE = 36;

    public static void processCounterReset(ICSSStyle style, HashMap counters) {
        Assert.isTrue((style != null && counters != null ? 1 : 0) != 0);
        Object counterResets = style.getStyleProperty("counter-reset");
        if (counterResets != null && counterResets != ICSSPropertyMeta.NOT_SPECIFIED && counterResets instanceof List) {
            List crList = (List)counterResets;
            int i = 0;
            int n = crList.size();
            while (i < n) {
                ResetObject rObject = (ResetObject)crList.get(i);
                String name = rObject.getCounterName();
                ICounterValueGenerator counter = null;
                if (counters.size() > 0 && counters.containsKey(name)) {
                    counter = (ICounterValueGenerator)counters.get(name);
                }
                if (counter != null) {
                    if (rObject.getInitial() != null) {
                        ((ICounterValueGenerator)counter).resetCount(rObject.getInitial());
                    } else {
                        counter = ((ICounterValueGenerator)counter).resetCount();
                    }
                    counters.put(counter.getIdentifier(), counter);
                } else {
                    Object listStyle = style.getStyleProperty("list-style-type");
                    if (listStyle instanceof String) {
                        counter = new CounterValueGenerator(name, (String)listStyle, null, style);
                        if (rObject.getInitial() != null) {
                            counter.resetCount(rObject.getInitial());
                        } else {
                            counter = counter.resetCount();
                        }
                    }
                    counters.put(counter.getIdentifier(), counter);
                }
                ++i;
            }
        }
    }

    public static void processCounterIncrement(ICSSStyle style) {
        Object counterIncrements = style.getStyleProperty("counter-increment");
        if (counterIncrements != null && counterIncrements != ICSSPropertyMeta.NOT_SPECIFIED && counterIncrements instanceof List) {
            List crList = (List)counterIncrements;
            int i = 0;
            int n = crList.size();
            while (i < n) {
                IncrementObject rObject = (IncrementObject)crList.get(i);
                String name = rObject.getCounterName();
                ICounterValueGenerator counter = null;
                counter = style.findCounter(name, true);
                if (counter != null) {
                    if (HTMLListInfoHelper.getValueInt(style) == null) {
                        if (rObject.getIncrement() != null) {
                            counter.increase(rObject.getIncrement());
                        } else {
                            counter.increase();
                        }
                    } else {
                        counter.setCount(HTMLListInfoHelper.getValueInt(style));
                    }
                }
                ++i;
            }
        }
    }

    public static boolean isText(ICSSStyle style) {
        String display = style.getDisplay();
        Object styleType = style.getStyleProperty("list-style-type");
        return display.equalsIgnoreCase("list-item") && styleType instanceof String && !CounterValueGenerator.NON_STRING_TYPES.contains(styleType);
    }

    public static int getType(ICSSStyle style) {
        Object type = style.getStyleProperty("list-style-type");
        if (type instanceof String) {
            return CounterHelper.toTypeInt((String)type);
        }
        return -1;
    }

    public static int toTypeInt(String type) {
        if (type.equalsIgnoreCase("decimal")) {
            return 17;
        }
        if (type.equalsIgnoreCase("decimal-leading-zero")) {
            return 18;
        }
        if (type.equalsIgnoreCase("disc")) {
            return 1;
        }
        if (type.equalsIgnoreCase("circle")) {
            return 2;
        }
        if (type.equalsIgnoreCase("square")) {
            return 3;
        }
        if (type.equalsIgnoreCase("image")) {
            return 0;
        }
        if (type.equalsIgnoreCase("upper-latin")) {
            return 21;
        }
        if (type.equalsIgnoreCase("upper-alpha")) {
            return 21;
        }
        if (type.equalsIgnoreCase("lower-latin")) {
            return 19;
        }
        if (type.equalsIgnoreCase("lower-alpha")) {
            return 19;
        }
        if (type.equalsIgnoreCase("upper-roman")) {
            return 22;
        }
        if (type.equalsIgnoreCase("lower-roman")) {
            return 20;
        }
        if (type.equalsIgnoreCase("lower-greek")) {
            return 33;
        }
        if (type.equalsIgnoreCase("armenian")) {
            return 34;
        }
        if (type.equalsIgnoreCase("georgian")) {
            return 35;
        }
        if (type.equalsIgnoreCase("none")) {
            return 36;
        }
        return 0;
    }

    public static boolean isIdentifier(Object cssValue) {
        return cssValue instanceof ICSSPrimitiveValue && ((ICSSPrimitiveValue)cssValue).getPrimitiveType() == 21;
    }

    public static boolean isNumber(Object cssValue) {
        return cssValue instanceof ICSSPrimitiveValue && ((ICSSPrimitiveValue)cssValue).getPrimitiveType() == 26;
    }

    private CounterHelper() {
    }
}

