/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.HttpHeadersValidator;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSI1102
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1102(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        block10: {
            String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
            String requestMessage = null;
            String contentType = null;
            this.result = null;
            try {
                String httpStatus = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
                if ("400".equals(httpStatus)) {
                    requestMessage = entryContext.getRequest().getMessage();
                    String requestHTTPHeaders = entryContext.getRequest().getHTTPHeaders();
                    if (!HttpHeadersValidator.validateHttpRequestHeaders(requestHTTPHeaders)) {
                        this.result = "passed";
                    }
                    if ((contentType = (String)HTTPUtils.getHttpHeaderTokens(httpHeader, ":").get("Content-Type".toUpperCase())).indexOf("text/xml") != -1) {
                        try {
                            if (requestMessage != null) {
                                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                DocumentBuilder builder = factory.newDocumentBuilder();
                                builder.parse(new InputSource(new StringReader(requestMessage)));
                            }
                        }
                        catch (SAXException sAXException) {
                            this.result = "passed";
                        }
                        catch (Exception e) {
                            new WSIException(e.getMessage(), e);
                        }
                    }
                    if (this.result == null) {
                        this.result = "warning";
                        this.failureDetail = this.validator.createFailureDetail("\nRequest message:\nHeaders:\n" + entryContext.getRequest().getHTTPHeaders() + "Message:\n" + entryContext.getRequest().getMessage() + "\n\nResponse message:\nHeaders:\n" + entryContext.getResponse().getHTTPHeaders() + "Message:\n" + entryContext.getResponse().getMessage(), entryContext);
                    }
                    break block10;
                }
                this.result = "notApplicable";
            }
            catch (WSIException wSIException) {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

