/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.CreateItemCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationEditPolicy;
import org.eclipse.jst.pagedesigner.itemcreation.ItemCreationRequest;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.DnDPositionValidator;
import org.eclipse.jst.pagedesigner.validation.caret.DropActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.w3c.dom.Node;

public class HeadItemCreationEditPolicy
extends ItemCreationEditPolicy {
    public HeadItemCreationEditPolicy(ElementEditPart host) {
        this.setHost((EditPart)host);
    }

    @Override
    public Command getCommand(Request request) {
        if (request instanceof ItemCreationRequest) {
            ItemCreationRequest r = (ItemCreationRequest)request;
            DesignPosition position = this.findPosition((ItemCreationRequest)request);
            if (position == null) {
                return null;
            }
            IDOMPosition domposition = DOMPositionHelper.toDOMPosition(position);
            if (domposition == null) {
                return null;
            }
            Node node = domposition.getContainerNode();
            domposition = new DOMPosition(node, node.getChildNodes().getLength());
            return new CreateItemCommand(PDPlugin.getResourceString("ItemCreationEditPolicy.CommandLabel.CreateItem"), this.getViewer((EditPart)this.getHost()).getModel(), domposition, r.getTagCreationProvider());
        }
        return null;
    }

    @Override
    protected IPositionMediator createDropChildValidator(DropRequest r) {
        DropActionData.DropData dropData = this.createDropData(r);
        if (dropData != null) {
            MyDnDPositionValidator validator = new MyDnDPositionValidator(new DropActionData(1, dropData));
            return validator;
        }
        return null;
    }

    private static class MyDnDPositionValidator
    extends DnDPositionValidator {
        public MyDnDPositionValidator(DropActionData dropActionData) {
            super(dropActionData);
        }

        @Override
        public boolean isValidPosition(IDOMPosition position) {
            Node node = null;
            if (position instanceof DOMRefPosition ? "head".equalsIgnoreCase((node = ((DOMRefPosition)position).getReferenceNode()).getLocalName()) : "head".equalsIgnoreCase((node = position.getContainerNode()).getLocalName())) {
                return true;
            }
            return super.isValidPosition(position);
        }
    }
}

