/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SwitchSelectionCommand
extends Command {
    IHTMLGraphicalViewer _viewer;

    public SwitchSelectionCommand(IHTMLGraphicalViewer viewer) {
        this._viewer = viewer;
    }

    public void execute() {
        if (this._viewer.isInRangeMode()) {
            ISelection selection = this._viewer.getSelection();
            if (selection instanceof DesignRange) {
                DesignPosition posStart = ((DesignRange)selection).getStartPosition();
                DesignPosition posEnd = ((DesignRange)selection).getEndPosition();
                if (EditValidateUtil.validPosition(posStart) && EditValidateUtil.validPosition(posEnd)) {
                    EditPart part;
                    Node ancestor = EditModelQuery.getInstance().getCommonAncestor(posStart.getContainerNode(), posEnd.getContainerNode());
                    if (ancestor instanceof Text) {
                        ancestor = ancestor.getParentNode();
                    }
                    if (ancestor instanceof Element && (part = Target.resolvePart(ancestor)) instanceof SubNodeEditPart) {
                        this._viewer.select(part);
                    }
                }
            }
        } else {
            EditPart parent;
            List parts = this._viewer.getSelectedEditParts();
            if (parts.size() > 0 && !((parent = ((EditPart)parts.get(0)).getParent()) instanceof DocumentEditPart)) {
                this._viewer.select(parent);
            }
        }
    }
}

