/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.xsd.impl;

import java.util.List;
import org.apache.axis.model.ecore.EAttribute;
import org.apache.axis.model.ecore.EClass;
import org.apache.axis.model.ecore.InternalEObject;
import org.apache.axis.model.ecore.impl.ENotificationImpl;
import org.apache.axis.model.xsd.XSDAnnotation;
import org.apache.axis.model.xsd.XSDConcreteComponent;
import org.apache.axis.model.xsd.XSDDiagnostic;
import org.apache.axis.model.xsd.XSDFactory;
import org.apache.axis.model.xsd.XSDFixedFacet;
import org.apache.axis.model.xsd.XSDLengthFacet;
import org.apache.axis.model.xsd.XSDMaxLengthFacet;
import org.apache.axis.model.xsd.XSDMinLengthFacet;
import org.apache.axis.model.xsd.XSDPackage;
import org.apache.axis.model.xsd.XSDSimpleTypeDefinition;
import org.apache.axis.model.xsd.impl.XSDFixedFacetImpl;
import org.apache.axis.model.xsd.util.XSDConstants;
import org.apache.axis.model.xsd.util.XSDUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDLengthFacetImpl
extends XSDFixedFacetImpl
implements XSDLengthFacet {
    protected static final int VALUE_EDEFAULT = 0;
    protected int value = 0;

    public static XSDLengthFacet createLengthFacet(Node node) {
        if (XSDConstants.nodeType(node) == 21) {
            XSDLengthFacet xsdLengthFacet = XSDFactory.eINSTANCE.createXSDLengthFacet();
            xsdLengthFacet.setElement((Element)node);
            return xsdLengthFacet;
        }
        return null;
    }

    protected XSDLengthFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_LENGTH_FACET;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return new Integer(this.getValue());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setValue((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setValue(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.value != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(21);
        this.setElement(newElement);
        return newElement;
    }

    public void validate() {
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        XSDMinLengthFacet xsdMinLengthFacet = xsdSimpleTypeDefinition.getMinLengthFacet();
        XSDMaxLengthFacet xsdMaxLengthFacet = xsdSimpleTypeDefinition.getMaxLengthFacet();
        if (xsdMinLengthFacet != null || xsdMaxLengthFacet != null) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "length-minLength-maxLength", this.getElement(), null, new Object[0]);
            if (xsdMinLengthFacet != null) {
                xsdDiagnostic.getComponents().add(xsdMinLengthFacet);
            }
            if (xsdMaxLengthFacet != null) {
                xsdDiagnostic.getComponents().add(xsdMaxLengthFacet);
            }
        }
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue() != ((XSDLengthFacet)xsdFixedFacet).getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "length-valid-restriction", this.getElement(), "value", new Object[]{new Integer(this.getValue()), xsdFixedFacet.getEffectiveValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add(xsdFixedFacet);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            if (this.getLexicalValue() == null) {
                this.setValue(0);
            } else {
                try {
                    int newValue = Integer.parseInt(this.getLexicalValue());
                    if (newValue != this.getValue()) {
                        this.setValue(newValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setValue(0);
                }
            }
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        if (value instanceof List) {
            return ((List)value).size() == this.getValue();
        }
        if (value instanceof String) {
            return ((String)value).length() == this.getValue();
        }
        if (value instanceof XSDUtil.ByteSequence) {
            return ((XSDUtil.ByteSequence)value).getBytes().length == this.getValue();
        }
        return false;
    }

    public Object getEffectiveValue() {
        return new Integer(this.getValue());
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDLengthFacetImpl clonedLengthFacet = (XSDLengthFacetImpl)this.getXSDFactory().createXSDLengthFacet();
        clonedLengthFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedLengthFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedLengthFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedLengthFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedLengthFacet.setElement(this.getElement());
        }
        clonedLengthFacet.isReconciling = shareDOM;
        return clonedLengthFacet;
    }
}

