/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.range;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.actions.range.DesignerToolBarAction;
import org.eclipse.jst.pagedesigner.commands.range.Paragraph;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphApplyStyleCommand;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphFinder;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParagraphStyleAction
extends DesignerToolBarAction {
    private String _tagName;
    private Node _applyingNode;

    public ParagraphStyleAction(String text, String name, ImageDescriptor image, int style) {
        super(text, style);
        this._tagName = name;
        this.setImageDescriptor(image);
    }

    public ParagraphStyleAction(String text, Node node, ImageDescriptor image, int style) {
        super(text, style);
        this._applyingNode = node;
        this.setImageDescriptor(image);
    }

    @Override
    protected boolean isApplied(DOMRange range) {
        Assert.isTrue((this.getExpectedTag() != null ? 1 : 0) != 0);
        if (range != null) {
            boolean ordered = range.isOrdered();
            IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
            IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
            Node common = null;
            if (EditModelQuery.isSame(range)) {
                ParagraphFinder finder = new ParagraphFinder(start);
                Paragraph p = finder.getParagraph(start);
                common = p.getLowestContainer();
            } else {
                common = EditModelQuery.getInstance().getCommonAncestor(start, end);
            }
            return this.containsTag(common);
        }
        return false;
    }

    protected boolean containsTag(Node common) {
        if (this._applyingNode == null) {
            return common.getNodeName() != null && this.getExpectedTag().equalsIgnoreCase(common.getNodeName().toLowerCase());
        }
        String align = ((Element)this._applyingNode).getAttribute("align");
        if (!(common instanceof Element)) {
            return false;
        }
        String cAlign = ((Element)common).getAttribute("align");
        if (align == null || cAlign == null) {
            return false;
        }
        return align.equals(cAlign);
    }

    public String getExpectedTag() {
        if (this._tagName == null) {
            return this._applyingNode.getNodeName().toLowerCase();
        }
        return this._tagName.toLowerCase();
    }

    public Element getApplyingNode() {
        if (this._applyingNode != null) {
            return (Element)this._applyingNode;
        }
        return null;
    }

    @Override
    protected Command getCommand() {
        ParagraphApplyStyleCommand command = null;
        command = this.getApplyingNode() != null ? new ParagraphApplyStyleCommand(this.getViewer(), this.getApplyingNode(), null, null) : new ParagraphApplyStyleCommand(this.getViewer(), this.getExpectedTag(), null, null);
        return command;
    }
}

