/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.resource.xml;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.resource.xml.EBaseObject;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class EBaseObjectImpl
extends EObjectImpl
implements EBaseObject {
    protected IDOMNode node;
    private static final Hashtable<Class<? extends EBaseObjectImpl>, HashSet<Integer>> insignificantFeatureIdSets = new Hashtable();

    protected EBaseObjectImpl() {
    }

    @Override
    public boolean isUnset() {
        for (EStructuralFeature feature : this.eClass().getEAllStructuralFeatures()) {
            if (!this.eIsSet(feature)) continue;
            return false;
        }
        return true;
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new XmlEAdapterList(this);
        }
        return this.eAdapters;
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch()) {
            super.eNotify(notification);
            this.featureChanged(notification.getFeatureID(this.getClass()));
        }
    }

    protected void featureChanged(int featureId) {
        if (this.featureIsSignificant(featureId)) {
            this.getXmlResource().resourceModelChanged();
        }
    }

    protected JptXmlResource getXmlResource() {
        return (JptXmlResource)this.eResource();
    }

    protected boolean featureIsSignificant(int featureId) {
        return !this.featureIsInsignificant(featureId);
    }

    protected boolean featureIsInsignificant(int featureId) {
        return this.insignificantFeatureIds().contains(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Integer> insignificantFeatureIds() {
        Hashtable<Class<? extends EBaseObjectImpl>, HashSet<Integer>> hashtable = insignificantFeatureIdSets;
        synchronized (hashtable) {
            HashSet<Integer> insignificantXmlFeatureIds = insignificantFeatureIdSets.get(this.getClass());
            if (insignificantXmlFeatureIds == null) {
                insignificantXmlFeatureIds = new HashSet();
                this.addInsignificantXmlFeatureIdsTo(insignificantXmlFeatureIds);
                insignificantFeatureIdSets.put(this.getClass(), insignificantXmlFeatureIds);
            }
            return insignificantXmlFeatureIds;
        }
    }

    protected void addInsignificantXmlFeatureIdsTo(Set<Integer> insignificantXmlFeatureIds) {
    }

    protected TextRange getTextTextRange() {
        IDOMNode textNode = this.getTextNode();
        return textNode != null ? this.buildTextRange(textNode) : this.getValidationTextRange();
    }

    protected IDOMNode getTextNode() {
        return this.selectTextNode(this.node.getChildNodes());
    }

    protected IDOMNode selectTextNode(NodeList nodes) {
        int i = 0;
        while (i < nodes.getLength()) {
            IDOMNode n = (IDOMNode)nodes.item(i);
            if (n.getNodeType() == 3) {
                return n;
            }
            ++i;
        }
        return null;
    }

    protected TextRange getAttributeTextRange(String attributeName) {
        IDOMAttr attributeNode = this.getAttributeNode(attributeName);
        return attributeNode != null ? this.buildTextRange((IDOMNode)attributeNode) : this.getValidationTextRange();
    }

    protected IDOMAttr getAttributeNode(String attributeName) {
        return (IDOMAttr)this.node.getAttributes().getNamedItem(attributeName);
    }

    protected TextRange getElementTextRange(String elementName) {
        IDOMNode elementNode = this.getElementNode(elementName);
        return elementNode != null ? this.buildTextRange(elementNode) : this.getValidationTextRange();
    }

    protected IDOMNode getElementNode(String elementName) {
        NodeList children = this.node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IDOMNode child = (IDOMNode)children.item(i);
            if (child.getNodeType() == 1 && elementName.equals(child.getNodeName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getFullTextRange();
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getFullTextRange();
    }

    @Override
    public TextRange getFullTextRange() {
        return this.buildTextRange(this.node);
    }

    protected TextRange buildTextRange(IDOMNode domNode) {
        return domNode == null ? null : this.buildTextRange_(domNode, null);
    }

    protected TextRange buildTextRange(IDOMNode domNode, TextRange textRange) {
        return domNode == null ? null : this.buildTextRange_(domNode, textRange);
    }

    protected TextRange buildTextRange_(IDOMNode domNode, TextRange textRange) {
        int offset = domNode.getStartOffset();
        int length = domNode.getNodeType() == 1 ? ((IDOMElement)domNode).getStartEndOffset() - offset : domNode.getLength();
        int lineNumber = domNode.getStructuredDocument().getLineOfOffset(offset) + 1;
        return textRange == null ? new SimpleTextRange(offset, length, lineNumber) : textRange.buildTextRange(offset, length, lineNumber);
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.node != null && this.node.contains(textOffset);
    }

    protected TextRange getAttributeCodeAssistTextRange(String attributeName) {
        IDOMAttr attributeNode = this.getAttributeNode(attributeName);
        return attributeNode != null ? this.buildTextRange((IDOMNode)attributeNode) : null;
    }

    protected TextRange getElementCodeAssistTextRange(String elementName) {
        IDOMNode elementNode = this.getElementNode(elementName);
        return elementNode != null ? this.buildElementCodeAssistTextRange(elementNode) : null;
    }

    protected TextRange buildElementCodeAssistTextRange(IDOMNode domNode) {
        return domNode == null ? null : this.buildElementCodeAssistTextRange(domNode, null);
    }

    protected TextRange buildElementCodeAssistTextRange(IDOMNode domNode, TextRange textRange) {
        return domNode == null ? null : this.buildElementCodeAssistTextRange_(domNode, textRange);
    }

    protected TextRange buildElementCodeAssistTextRange_(IDOMNode domNode, TextRange textRange) {
        int offset = domNode.getStartOffset();
        int length = domNode.getNodeType() == 1 ? ((IDOMElement)domNode).getEndStartOffset() - offset : domNode.getLength();
        int lineNumber = domNode.getStructuredDocument().getLineOfOffset(offset) + 1;
        return textRange == null ? new SimpleTextRange(offset, length, lineNumber) : textRange.buildTextRange(offset, length, lineNumber);
    }

    @Override
    public DeleteEdit createDeleteEdit() {
        int deletionOffset = this.getDeletionOffset();
        int deletionLength = this.node.getEndOffset() - deletionOffset;
        return new DeleteEdit(deletionOffset, deletionLength);
    }

    public int getNodeEndOffset() {
        return this.node.getEndOffset();
    }

    protected int getDeletionOffset() {
        int emptyTextLength = 0;
        Node previousSibling = this.node.getPreviousSibling();
        if (previousSibling != null && previousSibling.getNodeType() == 3) {
            emptyTextLength = ((Text)previousSibling).getLength();
        }
        return this.node.getStartOffset() - emptyTextLength;
    }

    protected static class XmlEAdapterList<E>
    extends BasicNotifierImpl.EAdapterList<E> {
        private static final long serialVersionUID = 1L;

        public XmlEAdapterList(EBaseObjectImpl jpaEObject) {
            super((Notifier)jpaEObject);
        }

        protected void didAdd(int index, E newObject) {
            Node n;
            super.didAdd(index, newObject);
            if (newObject instanceof EMF2DOMAdapter && (n = ((EMF2DOMAdapter)newObject).getNode()) instanceof IDOMNode) {
                ((EBaseObjectImpl)this.notifier).node = (IDOMNode)n;
            }
        }

        protected void didRemove(int index, E oldObject) {
            if (oldObject instanceof EMF2DOMAdapter && ((EMF2DOMAdapter)oldObject).getNode() == ((EBaseObjectImpl)this.notifier).node) {
                ((EBaseObjectImpl)this.notifier).node = null;
            }
            super.didRemove(index, oldObject);
        }
    }
}

