/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmNullAttributeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;

public class GraphicalAddAttributeFeature
extends AbstractAddShapeFeature {
    public GraphicalAddAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public PictogramElement add(final IAddContext context) {
        final ContainerShape entityShape = context.getTargetContainer();
        final Wrp wrp = new Wrp();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)entityShape);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                PersistentAttribute newAttr = (PersistentAttribute)context.getNewObject();
                String txt = JPAEditorUtil.getText(newAttr);
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(newAttr);
                ContainerShape textShape = null;
                ContainerShape primaryShape = GraphicsUpdater.getPrimaryShape(entityShape);
                ContainerShape relationShape = GraphicsUpdater.getRelationShape(entityShape);
                ContainerShape basicShape = GraphicsUpdater.getBasicShape(entityShape);
                textShape = GraphicalAddAttributeFeature.this.addAttributeToProperlyShape(entityShape, txt, attributeMapping, primaryShape, relationShape, basicShape);
                GraphicalAddAttributeFeature.this.link((PictogramElement)textShape, newAttr);
                GraphicalAddAttributeFeature.this.layoutPictogramElement((PictogramElement)entityShape);
                wrp.setObj(textShape);
            }
        });
        return (PictogramElement)wrp.getObj();
    }

    private ContainerShape addAttributeToProperlyShape(ContainerShape entityShape, String txt, AttributeMapping attributeMapping, ContainerShape primaryShape, ContainerShape relationShape, ContainerShape basicShape) {
        DerivedIdentity2_0 identity;
        ContainerShape textShape = null;
        textShape = attributeMapping instanceof IdMapping || attributeMapping instanceof EmbeddedIdMapping ? this.addAttributeToShape(entityShape, txt, attributeMapping, primaryShape) : (attributeMapping instanceof SingleRelationshipMapping2_0 ? ((identity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity()).usesIdDerivedIdentityStrategy() || identity.usesMapsIdDerivedIdentityStrategy() ? this.addAttributeToShape(entityShape, txt, attributeMapping, primaryShape) : this.addAttributeToShape(entityShape, txt, attributeMapping, relationShape)) : (attributeMapping instanceof RelationshipMapping ? this.addAttributeToShape(entityShape, txt, attributeMapping, relationShape) : this.addAttributeToShape(entityShape, txt, attributeMapping, basicShape)));
        return textShape;
    }

    private ContainerShape addAttributeToShape(ContainerShape entityShape, String txt, AttributeMapping attributeMapping, ContainerShape containerShape) {
        ContainerShape textShape = null;
        int childrenSizeBefore = containerShape.getChildren().size();
        int containerHeightBefore = containerShape.getGraphicsAlgorithm().getHeight();
        textShape = GraphicalAddAttributeFeature.addAttribute(this.getFeatureProvider(), containerShape, txt, attributeMapping);
        GraphicsUpdater.updateContainer(containerShape, childrenSizeBefore, containerHeightBefore);
        GraphicsUpdater.updateEntityShape(entityShape);
        return textShape;
    }

    private static ContainerShape addAttribute(IJPAEditorFeatureProvider fp, ContainerShape containerShape, String attribTxt, AttributeMapping attributeMapping) {
        int width = containerShape.getContainer().getGraphicsAlgorithm().getWidth();
        ContainerShape iconShape = Graphiti.getPeService().createContainerShape(containerShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)iconShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.ICON.toString());
        int attribIndex = fp.getAttribsNum((Shape)containerShape);
        Rectangle iconRect = UpdateAttributeFeature.addRectangleForIcon(iconShape, attribIndex);
        Image icon = null;
        boolean isCollection = JpaArtifactFactory.instance().isCollection(attributeMapping);
        icon = isCollection && (attributeMapping instanceof GenericJavaNullAttributeMapping || attributeMapping instanceof GenericOrmNullAttributeMapping) ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.unmapped") : JPAEditorUtil.createAttributeIcon(iconRect, attributeMapping);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)icon, 4, 4, 16, 16);
        ContainerShape textShape = Graphiti.getPeService().createContainerShape(containerShape, false);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)textShape, JPAEditorConstants.PROP_SHAPE_TYPE, JPAEditorConstants.ShapeType.ATTRIBUTE.toString());
        Rectangle textRectangle = UpdateAttributeFeature.addRectangleForText(textShape, attribIndex, width);
        textShape.setActive(true);
        Text text = UpdateAttributeFeature.addText(fp, textRectangle, attribTxt);
        Graphiti.getGaService().setWidth((GraphicsAlgorithm)text, width - 21);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)text, 1, -2, width - 21, 30);
        fp.increaseAttribsNum((Shape)containerShape);
        return textShape;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public boolean canAdd(IAddContext context) {
        return false;
    }
}

