/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.BindingPriority;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.StubValue;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.easymock.ConstructorArgs;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.ClassInstantiatorFactory;
import org.easymock.internal.ClassMockingData;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.IgnoreAnimalSniffer;
import org.easymock.internal.MockInvocationHandler;

public class ClassProxyFactory
implements IProxyFactory {
    private static final String CALLBACK_FIELD = "$callback";
    private static final AtomicInteger id = new AtomicInteger(0);
    private static final ThreadLocal<ClassMockingData> currentData = new ThreadLocal();
    private final TypeCache<Class<?>> typeCache = new TypeCache.WithInlineExpunction();

    public static boolean isCallerMockInvocationHandlerInvoke(Throwable e) {
        StackTraceElement[] elements = e.getStackTrace();
        return elements.length > 2 && elements[2].getClassName().equals(MockInvocationHandler.class.getName()) && elements[2].getMethodName().equals("invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @IgnoreAnimalSniffer
    public <T> T createProxy(Class<T> toMock, InvocationHandler handler, Method[] mockedMethods, ConstructorArgs args) {
        Object mock;
        ClassMockingData classMockingData;
        block14: {
            ElementMatcher.Junction junction = ElementMatchers.any();
            ClassLoader classLoader = this.classLoader(toMock);
            Class mockClass = this.typeCache.findOrInsert(classLoader, toMock, () -> {
                try (DynamicType.Unloaded unloaded = new ByteBuddy().subclass(toMock).name(this.classPackage(toMock) + toMock.getSimpleName() + "$$$EasyMock$" + id.incrementAndGet()).defineField(CALLBACK_FIELD, ClassMockingData.class, new ModifierContributor.ForField[]{SyntheticState.SYNTHETIC, Visibility.PUBLIC}).method((ElementMatcher)junction).intercept((Implementation)MethodDelegation.to(MockMethodInterceptor.class)).make();){
                    Class clazz = unloaded.load(classLoader, this.classLoadingStrategy()).getLoaded();
                    return clazz;
                }
            });
            classMockingData = new ClassMockingData(handler, mockedMethods);
            if (args != null) {
                Constructor cstr;
                try {
                    cstr = mockClass.getDeclaredConstructor(args.getConstructor().getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Fail to find constructor for param types", e);
                }
                try {
                    cstr.setAccessible(true);
                    currentData.set(classMockingData);
                    try {
                        mock = cstr.newInstance(args.getInitArgs());
                        break block14;
                    }
                    finally {
                        currentData.remove();
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor: Exception in constructor", e.getTargetException());
                }
            }
            try {
                mock = ClassInstantiatorFactory.getInstantiator().newInstance(mockClass);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Fail to instantiate mock for " + toMock + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
            }
        }
        MethodHandle callbackField = ClassProxyFactory.getCallbackSetter(mock);
        try {
            callbackField.invoke(mock, classMockingData);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return (T)mock;
    }

    private String classPackage(Class<?> toMock) {
        if (ClassProxyFactory.isJdkClassOrWithoutPackage(toMock)) {
            return "org.easymock.mocks.";
        }
        return toMock.getPackage().getName() + ".";
    }

    private <T> ClassLoader classLoader(Class<T> toMock) {
        return ClassProxyFactory.isJdkClassOrWithoutPackage(toMock) ? this.getClass().getClassLoader() : toMock.getClassLoader();
    }

    private static <T> boolean isJdkClassOrWithoutPackage(Class<T> toMock) {
        return toMock.getPackage() == null || toMock.getClassLoader() == null || toMock.getName().startsWith("java.");
    }

    private ClassLoadingStrategy<ClassLoader> classLoadingStrategy() {
        if (ClassInjector.UsingUnsafe.isAvailable()) {
            return new ClassLoadingStrategy.ForUnsafeInjection();
        }
        return ClassLoadingStrategy.UsingLookup.of((Object)MethodHandles.lookup());
    }

    @Override
    public InvocationHandler getInvocationHandler(Object mock) {
        return ClassProxyFactory.getMockingData(mock).handler();
    }

    @IgnoreAnimalSniffer
    private static ClassMockingData getMockingData(Object mock) {
        MethodHandle field = ClassProxyFactory.getCallbackGetter(mock);
        try {
            return field.invoke(mock);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle getCallbackGetter(Object mock) {
        try {
            return MethodHandles.lookup().findGetter(mock.getClass(), CALLBACK_FIELD, ClassMockingData.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle getCallbackSetter(Object mock) {
        try {
            return MethodHandles.lookup().findSetter(mock.getClass(), CALLBACK_FIELD, ClassMockingData.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MockMethodInterceptor
    implements Serializable {
        private static final long serialVersionUID = -9054190871232972342L;

        @RuntimeType
        @BindingPriority(value=2)
        public static Object interceptSuperCallable(@This Object obj, @FieldValue(value="$callback") ClassMockingData mockingData, @Origin Method method, @AllArguments Object[] args, @SuperCall(serializableProxy=true) Callable<?> superCall) throws Throwable {
            if (obj instanceof Throwable && method.getName().equals("fillInStackTrace") && ClassProxyFactory.isCallerMockInvocationHandlerInvoke(new Throwable())) {
                return obj;
            }
            if (method.isBridge()) {
                method = BridgeMethodResolver.findBridgedMethod(method);
            }
            if ((mockingData = MockMethodInterceptor.mockingData(mockingData)) != null && mockingData.isMocked(method)) {
                return mockingData.handler().invoke(obj, method, args);
            }
            return superCall.call();
        }

        private static ClassMockingData mockingData(ClassMockingData mockingData) {
            if (mockingData != null) {
                return mockingData;
            }
            return (ClassMockingData)currentData.get();
        }

        @RuntimeType
        public static Object interceptAbstract(@This Object obj, @FieldValue(value="$callback") ClassMockingData mockingData, @StubValue Object stubValue, @Origin Method method, @AllArguments Object[] args) throws Throwable {
            return mockingData.handler().invoke(obj, method, args);
        }
    }
}

