/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.layout.tests;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.License;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.wtp.releng.tests.TestActivator;
import org.osgi.framework.BundleContext;

public class TestRepo
extends TestCase {
    private static final String NBSP = " &nbsp; ";
    static final String JUNIT_REPORT_OUTPUT = "junit-report-output";
    private static final String EXPECTED_PROVIDER_NAME = "Eclipse Web Tools Platform";
    static final String defaultURLToTest = "http://download.eclipse.org/releases/staging";
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final boolean DEBUG = false;
    private static final String OLD_PROVIDER_NAME = "Eclipse.org";
    private String repoURLToTest;

    public static Test suite() {
        System.out.println("suite for layout");
        return new TestSuite(TestRepo.class);
    }

    public void testLicenses() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        String repoURL = this.getrepoURLToTest();
        URI repoLocation = new URI(repoURL);
        IMetadataRepository repo = TestRepo.getMetadataRepositoryManager().loadRepository(repoLocation, null);
        if (repo == null) {
            System.out.println("no repository found at " + repoLocation.toString());
        } else {
            IQueryResult allFeatures = repo.query(QueryUtil.createIUGroupQuery(), null);
            TestRepo.assertFalse((boolean)allFeatures.isEmpty());
            Properties properties = new Properties();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("standard.properties");
            properties.load(inStream);
            String body = properties.getProperty("license");
            License standardLicense = new License(null, body, null);
            ArrayList<IInstallableUnit> noLicense = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> extraLicense = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> goodLicense = new ArrayList<IInstallableUnit>();
            ArrayList<IInstallableUnit> badLicense = new ArrayList<IInstallableUnit>();
            this.checkLicenses((ILicense)standardLicense, (IQueryResult<IInstallableUnit>)allFeatures, goodLicense, badLicense, noLicense, extraLicense);
            this.printReport(goodLicense, badLicense, noLicense, extraLicense);
        }
    }

    private void printReport(List<IInstallableUnit> goodLicense, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        File outfile;
        block18: {
            String SPACER = "<br />=======================";
            OutputStreamWriter outfileWriter = null;
            outfile = null;
            String testDirName = System.getProperty(JUNIT_REPORT_OUTPUT);
            try {
                try {
                    outfile = new File(testDirName, "licenseConsistency.html");
                    outfileWriter = new FileWriter(outfile);
                    this.println((FileWriter)outfileWriter, "<br /><br />Summary:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features with conforming license: " + goodLicense.size());
                    this.println((FileWriter)outfileWriter, "Features with different license: " + badLicense.size());
                    this.println((FileWriter)outfileWriter, "Features with no license: " + noLicense.size());
                    this.println((FileWriter)outfileWriter, "Features with extra licenses: " + extraLicense.size());
                    this.println((FileWriter)outfileWriter, "=======================");
                    this.println((FileWriter)outfileWriter, "<br /><br />Details:" + SPACER);
                    this.println((FileWriter)outfileWriter, "Features with no license:" + SPACER);
                    for (IInstallableUnit unit : this.sort(noLicense)) {
                        this.println((FileWriter)outfileWriter, unit.getId());
                    }
                    this.println((FileWriter)outfileWriter, "<br /><br />Features with different license:" + SPACER);
                    for (IInstallableUnit unit : this.sort(badLicense)) {
                        this.println((FileWriter)outfileWriter, unit.getId());
                    }
                    this.println((FileWriter)outfileWriter, "<br /><br />Features with matching license:" + SPACER);
                    for (IInstallableUnit unit : this.sort(goodLicense)) {
                        this.println((FileWriter)outfileWriter, unit.getId());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (outfileWriter != null) {
                        try {
                            outfileWriter.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (outfileWriter != null) {
                    try {
                        outfileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (badLicense.size() > 0 || extraLicense.size() > 0 || noLicense.size() > 0) {
            TestRepo.fail((String)("Errors in license consistency. For list, see " + outfile.getAbsolutePath()));
        }
    }

    private void println(FileWriter out, String string) throws IOException {
        out.write("<li>" + string + "</li>" + EOL);
    }

    private List<IInstallableUnit> sort(List<IInstallableUnit> noLicense) {
        Collections.sort(noLicense);
        return noLicense;
    }

    private void checkLicenses(ILicense platformLicense, IQueryResult<IInstallableUnit> allFeatures, List<IInstallableUnit> goodLicense, List<IInstallableUnit> badLicense, List<IInstallableUnit> noLicense, List<IInstallableUnit> extraLicense) {
        for (IInstallableUnit feature : allFeatures.toUnmodifiableSet()) {
            if (!feature.getId().endsWith(".feature.group")) continue;
            Collection licenses = feature.getLicenses(null);
            if (licenses.isEmpty()) {
                noLicense.add(feature);
                continue;
            }
            if (licenses.size() != 1) {
                extraLicense.add(feature);
                continue;
            }
            ILicense featureLicense = (ILicense)licenses.iterator().next();
            if (!platformLicense.getUUID().equals(featureLicense.getUUID())) {
                badLicense.add(feature);
                continue;
            }
            goodLicense.add(feature);
        }
    }

    private void checkProviderNames(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> incorrectProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> correctProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> incorrectOldProviderName = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> probablyCorrectProviderName = new ArrayList<IInstallableUnit>();
        String testDirName = System.getProperty(JUNIT_REPORT_OUTPUT);
        try {
            outfile = new File(testDirName, "providerNames.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
                try {
                    boolean isSpecial;
                    boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                    "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
                    boolean bl = isSpecial = "a.jre".equals(iu.getId()) || "config.a.jre".equals(iu.getId());
                    if (isCategory || isSpecial) continue;
                    String providerName = iu.getProperty("org.eclipse.equinox.p2.provider", null);
                    if (EXPECTED_PROVIDER_NAME.equals(providerName)) {
                        correctProviderName.add(iu);
                        continue;
                    }
                    if (OLD_PROVIDER_NAME.equals(providerName)) {
                        incorrectOldProviderName.add(iu);
                        continue;
                    }
                    if (providerName != null && providerName.startsWith("Eclipse")) {
                        probablyCorrectProviderName.add(iu);
                        continue;
                    }
                    incorrectProviderName.add(iu);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            outfileWriter.write("<h1>Provider names used in repository</h1>" + EOL);
            outfileWriter.write("<p>Repository ('repoURLToTest'): " + this.getrepoURLToTest() + "</p>" + EOL);
            outfileWriter.write("<p>Note, there are several problems with this test, e.g. see <a href=\"https://bugs.eclipse.org/bugs/show_bug.cgi?id=309566\">bug 309566</a>. So provided here as FYI for now.</p>" + EOL);
            outfileWriter.write("<h2>Major missing, or possibly incorrect provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, incorrectProviderName);
            outfileWriter.write("<h2>Minor problem of using old style provider name (todo: filter out non-wtp ones)</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, incorrectOldProviderName);
            outfileWriter.write("<h2>Probably correct provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, probablyCorrectProviderName);
            outfileWriter.write("<h2>Using correct provider name</h2>" + EOL);
            this.printLinesProvider((FileWriter)outfileWriter, correctProviderName);
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printLinesProvider(FileWriter out, List<IInstallableUnit> iuList) throws IOException {
        Comparator<IInstallableUnit> comparatorProviderName = new Comparator<IInstallableUnit>(){

            @Override
            public int compare(IInstallableUnit iu1, IInstallableUnit iu2) {
                int result;
                if (iu1 == null && iu2 == null) {
                    return 0;
                }
                if (iu1 == null || iu2 == null) {
                    return 1;
                }
                String p1 = iu1.getProperty("org.eclipse.equinox.p2.provider", null);
                String p2 = iu2.getProperty("org.eclipse.equinox.p2.provider", null);
                if (p1 == null) {
                    p1 = "null";
                }
                if (p2 == null) {
                    p2 = "null";
                }
                if ((result = p1.compareTo(p2)) == 0) {
                    result = iu1.getId().compareTo(iu2.getId());
                }
                return result;
            }
        };
        Collections.sort(iuList, comparatorProviderName);
        out.write("<p>Count: " + iuList.size() + EOL);
        out.write("<ol>" + EOL);
        for (IInstallableUnit iu : iuList) {
            this.printLineListItem(out, iu);
        }
        out.write("</ol>" + EOL);
    }

    private void printLinesCopyright(FileWriter out, List<IInstallableUnit> iuList) throws IOException {
        Collections.sort(iuList);
        out.write("<p>Count: " + iuList.size() + EOL);
        out.write("<ol>" + EOL);
        for (IInstallableUnit iu : iuList) {
            this.printLineCopyright(out, iu);
        }
        out.write("</ol>" + EOL);
    }

    private void printLineListItem(FileWriter outfileWriter, IInstallableUnit iu) throws IOException {
        String providerName = iu.getProperty("org.eclipse.equinox.p2.provider", null);
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        this.println(outfileWriter, String.valueOf(providerName) + NBSP + iuId + NBSP + iuVersion + NBSP);
    }

    private void printLineCopyright(FileWriter outfileWriter, IInstallableUnit iu) throws IOException {
        String copyright = null;
        ICopyright copyrightIu = iu.getCopyright(null);
        if (copyrightIu != null) {
            copyright = copyrightIu.getBody();
        }
        String iuId = iu.getId();
        String iuVersion = iu.getVersion().toString();
        this.println(outfileWriter, String.valueOf(copyright) + NBSP + iuId + NBSP + iuVersion + NBSP);
    }

    private void printProperties(FileWriter outFileWriter, IInstallableUnit iu) throws IOException {
        Map properties = iu.getProperties();
        Set keys = properties.keySet();
        for (Object key : keys) {
            String value = (String)properties.get(key);
            this.println(outFileWriter, "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + key + " : " + value);
        }
    }

    public void testProviderNames() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUs();
        this.checkProviderNames(allIUs);
    }

    public void testCopyrights() throws URISyntaxException, ProvisionException, OperationCanceledException, IOException {
        IQueryResult<IInstallableUnit> allIUs = this.getAllIUs();
        this.checkCopyrights(allIUs);
    }

    private IQueryResult<IInstallableUnit> getAllIUs() throws URISyntaxException, ProvisionException {
        String repoURL = this.getrepoURLToTest();
        URI repoLocation = new URI(repoURL);
        IMetadataRepository repo = TestRepo.getMetadataRepositoryManager().loadRepository(repoLocation, null);
        TestRepo.assertNotNull((String)("no repository found at " + repoLocation.toString()), (Object)repo);
        IQueryResult allIUs = repo.query(QueryUtil.createIUAnyQuery(), null);
        TestRepo.assertFalse((boolean)allIUs.isEmpty());
        return allIUs;
    }

    private String getrepoURLToTest() {
        if (this.repoURLToTest == null) {
            this.repoURLToTest = System.getProperty("repoURLToTest");
            if (this.repoURLToTest == null) {
                this.repoURLToTest = defaultURLToTest;
                System.out.println("the 'repoURLToTest' property was not defined, will use default");
            }
            System.out.println("repoURLToTest: " + this.repoURLToTest);
        }
        return this.repoURLToTest;
    }

    private void checkCopyrights(IQueryResult<IInstallableUnit> allIUs) throws IOException {
        OutputStreamWriter outfileWriter = null;
        File outfile = null;
        ArrayList<IInstallableUnit> correctcopyright = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> nocopyright = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> incorrectcopyright = new ArrayList<IInstallableUnit>();
        String testDirName = System.getProperty(JUNIT_REPORT_OUTPUT);
        try {
            outfile = new File(testDirName, "copyrights.html");
            outfileWriter = new FileWriter(outfile);
            System.out.println("output: " + outfile.getAbsolutePath());
            for (IInstallableUnit iu : allIUs.toUnmodifiableSet()) {
                boolean isSpecial;
                boolean isCategory = "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
                "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.fragment"));
                boolean bl = isSpecial = "a.jre".equals(iu.getId()) || "config.a.jre".equals(iu.getId());
                if (isCategory || isSpecial) continue;
                ICopyright copyright = iu.getCopyright(null);
                if (copyright == null) {
                    nocopyright.add(iu);
                    continue;
                }
                if (copyright.getBody().trim().startsWith("Copyright")) {
                    correctcopyright.add(iu);
                    continue;
                }
                incorrectcopyright.add(iu);
            }
            outfileWriter.write("<h1>Copyrights used in latest build</h1>" + EOL);
            outfileWriter.write("<p>This (simple) test is base on heuristic that a valid copyright is not null and starts with 'Copyright'. </p>" + EOL);
            outfileWriter.write("<h2>key only? or incorrect copyright?</h2>" + EOL);
            this.printLinesCopyright((FileWriter)outfileWriter, incorrectcopyright);
            outfileWriter.write("<h2>No copyright. (which is ok and expected for bundle IUs, as far as is known)</h2>" + EOL);
            this.printLinesCopyright((FileWriter)outfileWriter, nocopyright);
            outfileWriter.write("<h2>Apparently using copyright, based on heuristic.</h2>" + EOL);
            this.printLinesCopyright((FileWriter)outfileWriter, correctcopyright);
            if (incorrectcopyright.size() > 0) {
                TestRepo.fail((String)("Errors in copyright statement? For list, see " + outfile.getAbsolutePath()));
            }
        }
        finally {
            if (outfileWriter != null) {
                try {
                    outfileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)TestRepo.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    protected static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }
}

