/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;

public class DefaultDTPropertyResolver
extends AbstractDTPropertyResolver {
    private static final String UICOMPONENT_SYMBOL_SIGNATURE = "Ljavax.faces.component.UIComponent;";
    private static final String ATTRS_SYMBOL_NAME = "attrs";
    private JSFSymbolFactory _symbolFactory = new JSFSymbolFactory();
    private IProject _project = null;

    @Override
    public ISymbol getProperty(ISymbol base, Object propertyId) {
        ISymbol matchedSymbol;
        ITypeDescriptor typeDesc = null;
        Object[] factoredProperties = new Object[]{propertyId};
        if (base instanceof IObjectSymbol) {
            IObjectSymbol objSymbol = (IObjectSymbol)base;
            typeDesc = objSymbol.getTypeDescriptor();
            if (objSymbol.supportsCoercion("Ljava.util.List;")) {
                typeDesc = null;
            } else if (objSymbol.supportsCoercion("Ljava.util.Map;")) {
                BasicEList args = new BasicEList();
                args.add((Object)new StringLiteralType(propertyId.toString()));
                ISymbol prop = objSymbol.call("get", (EList)args, propertyId.toString());
                if (prop != null) {
                    return prop;
                }
                typeDesc = objSymbol.coerce("Ljava.util.Map;");
                if (propertyId instanceof String && ((String)propertyId).indexOf(46) > -1) {
                    factoredProperties = this.factorKey(propertyId);
                }
            } else if (propertyId instanceof String && ((String)propertyId).equals(ATTRS_SYMBOL_NAME)) {
                return this.getCCAttrsSymbolIfNecessary(typeDesc);
            }
            if (typeDesc instanceof IBoundedTypeDescriptor && ((IBoundedTypeDescriptor)typeDesc).isUnboundedForType("Ljava.lang.Object;")) {
                return ((IBoundedTypeDescriptor)typeDesc).getUnboundedProperty(propertyId, "Ljava.lang.Object;");
            }
        }
        int i = 0;
        block0: do {
            matchedSymbol = null;
            Iterator it = this.getIterator(typeDesc);
            while (it.hasNext()) {
                ISymbol element = (ISymbol)it.next();
                if (!element.getName().equals(factoredProperties[i]) || !(element instanceof IObjectSymbol)) continue;
                matchedSymbol = element;
                typeDesc = ((IObjectSymbol)matchedSymbol).getTypeDescriptor();
                continue block0;
            }
        } while (++i < factoredProperties.length && matchedSymbol != null);
        return matchedSymbol;
    }

    @Override
    public ISymbol[] getAllProperties(ISymbol base) {
        List symbolsList = Collections.EMPTY_LIST;
        if (base instanceof IObjectSymbol) {
            Object typeDesc = null;
            typeDesc = ((IObjectSymbol)base).supportsCoercion("Ljava.util.Map;") ? ((IObjectSymbol)base).coerce("Ljava.util.Map;") : (((IObjectSymbol)base).supportsCoercion("Ljava.util.List;") ? null : ((IObjectSymbol)base).getTypeDescriptor());
            if (typeDesc != null) {
                symbolsList = typeDesc.getProperties();
                this.addCCAttrsIfNecessary((ITypeDescriptor)typeDesc, symbolsList);
            }
        }
        return symbolsList.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    @Override
    public ISymbol getProperty(ISymbol base, int offset) {
        ITypeDescriptor typeDesc = null;
        if (offset < 0) {
            throw new AssertionError((Object)"offsets must be >=0 to be valid");
        }
        if (base instanceof IObjectSymbol) {
            IObjectSymbol objSymbol = (IObjectSymbol)base;
            typeDesc = objSymbol.getTypeDescriptor();
            if (typeDesc.isArray()) {
                IObjectSymbol arrayElement = typeDesc.getArrayElement();
                arrayElement.setName(base.getName() + "[" + offset + "]");
                return arrayElement;
            }
            if (objSymbol.supportsCoercion("Ljava.util.List;")) {
                BasicEList args = new BasicEList();
                args.add((Object)new ValueType("I", 2));
                return objSymbol.call("get", (EList)args, base.getName() + "[" + offset + "]");
            }
            return this.getCCAttrsSymbolIfNecessary(typeDesc);
        }
        return null;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    private ISymbol getCCAttrsSymbolIfNecessary(ITypeDescriptor typeDesc) {
        IInstanceSymbol attrsSymbol = null;
        if (typeDesc.instanceOf(UICOMPONENT_SYMBOL_SIGNATURE) && JSFAppConfigUtils.isValidJSFProject(this._project, "2.0")) {
            attrsSymbol = this._symbolFactory.createUnknownInstanceSymbol(ATTRS_SYMBOL_NAME, ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        }
        return attrsSymbol;
    }

    private void addCCAttrsIfNecessary(ITypeDescriptor typeDesc, List symbolsList) {
        ISymbol attrsSymbol = this.getCCAttrsSymbolIfNecessary(typeDesc);
        if (attrsSymbol != null) {
            symbolsList.add(attrsSymbol);
        }
    }

    protected final Iterator getIterator(ITypeDescriptor typeDesc) {
        if (typeDesc != null) {
            return typeDesc.getProperties().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected final Object[] factorKey(Object key) {
        if (key instanceof String) {
            ArrayList<String> segments = new ArrayList<String>();
            String stringKey = (String)key;
            int nextPos = -1;
            while ((nextPos = stringKey.indexOf(46)) > -1) {
                segments.add(stringKey.substring(0, nextPos));
                stringKey = stringKey.substring(nextPos + 1);
            }
            if (stringKey != null && stringKey.length() > 0) {
                segments.add(stringKey);
            }
            return segments.toArray();
        }
        return new Object[]{key};
    }
}

