/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.DomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;

public class DomainLoadingStrategyRegistry {
    private static DomainLoadingStrategyRegistry INSTANCE;
    private HashMap<String, DomainLoadingStrategyDescriptorImpl> domainLoadingStrategyDescriptors;
    private static final String EXTENSION_POINT_ID = "domainLoadingStrategies";

    private DomainLoadingStrategyRegistry() {
        this.init();
    }

    public static synchronized DomainLoadingStrategyRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DomainLoadingStrategyRegistry();
        }
        return INSTANCE;
    }

    final synchronized void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("org.eclipse.jst.jsf.common", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                DomainLoadingStrategyDescriptorImpl dls = new DomainLoadingStrategyDescriptorImpl(element);
                this.addDomainLoadingStrategyDescriptor(dls);
                ++i;
            }
        }
    }

    protected void addDomainLoadingStrategyDescriptor(DomainLoadingStrategyDescriptorImpl strategy) {
        if (this.getDescriptors().containsKey(strategy.getDomain())) {
            if (!strategy.getBundleId().equals("org.eclipse.jst.jsf.common")) {
                this.getDescriptors().put(strategy.getDomain(), strategy);
            }
        } else {
            this.getDescriptors().put(strategy.getDomain(), strategy);
        }
    }

    public IDomainLoadingStrategy getLoadingStrategy(String domain) {
        DomainLoadingStrategyDescriptorImpl strategy = this.getDescriptors().get(domain);
        if (strategy == null) {
            return this.createDefaultLoadingStrategy();
        }
        return this.createLoadingStrategy(domain);
    }

    private IDomainLoadingStrategy createDefaultLoadingStrategy() {
        return new DomainLoadingStrategy(null);
    }

    private IDomainLoadingStrategy createLoadingStrategy(String domain) {
        return this.getDescriptors().get(domain).newInstance();
    }

    private Map<String, DomainLoadingStrategyDescriptorImpl> getDescriptors() {
        if (this.domainLoadingStrategyDescriptors == null) {
            this.domainLoadingStrategyDescriptors = new HashMap();
        }
        return this.domainLoadingStrategyDescriptors;
    }

    private static class DomainLoadingStrategyDescriptorImpl {
        String domain;
        String loadingStrategyClassName;
        String bundleId;
        Class strategy;
        IConfigurationElement element;

        DomainLoadingStrategyDescriptorImpl(IConfigurationElement element) {
            this.element = element;
            this.init();
        }

        private void init() {
            this.domain = this.element.getAttribute("domainId");
            this.bundleId = this.element.getContributor().getName();
            this.loadingStrategyClassName = this.element.getAttribute("domainLoadingStrategy");
        }

        public String getDomain() {
            return this.domain;
        }

        public String getBundleId() {
            return this.bundleId;
        }

        public IDomainLoadingStrategy newInstance() {
            try {
                Class[] parameterTypes = new Class[]{String.class};
                Object[] initargs = new Object[]{this.domain};
                Object loader = this.getLoadingStrategy().getConstructor(parameterTypes).newInstance(initargs);
                if (loader instanceof IDomainLoadingStrategy) {
                    return (IDomainLoadingStrategy)loader;
                }
            }
            catch (InstantiationException e) {
                JSFCommonPlugin.log(4, "Unable to instantiate IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (IllegalAccessException e) {
                JSFCommonPlugin.log(4, "IllegalAccessException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (IllegalArgumentException e) {
                JSFCommonPlugin.log(4, "IllegalArgumentException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (SecurityException e) {
                JSFCommonPlugin.log(4, "SecurityException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (InvocationTargetException e) {
                JSFCommonPlugin.log(4, "InvocationTargetException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (NoSuchMethodException e) {
                JSFCommonPlugin.log(4, "NoSuchMethodException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            return null;
        }

        private Class getLoadingStrategy() {
            if (this.strategy == null) {
                this.strategy = JSFCommonPlugin.loadClass(this.loadingStrategyClassName, this.bundleId);
            }
            return this.strategy;
        }
    }
}

