/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.test.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.test.util.ZipStreamWrapper;
import org.osgi.framework.Bundle;

public class TestUtil {
    private static final String TEST_FILE_FOLDER = "/test-file/";

    public static IProject createProjectFromZip(String prjname, String path) throws Exception {
        URL url = FileLocator.find((Bundle)EditorPlugin.getDefault().getBundle(), (IPath)new Path(TEST_FILE_FOLDER + path), null);
        InputStream stream = url.openStream();
        return TestUtil.createProjectFromZip(prjname, stream);
    }

    public static IProject createProjectFromZip(final String prjname, final InputStream zipStream) throws Exception {
        final IProject[] holder = new IProject[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjname);
                if (!prj.exists()) {
                    prj.create(null);
                }
                prj.open(null);
                try {
                    TestUtil.expandZip(zipStream, (IContainer)prj);
                }
                catch (Exception ex) {
                    throw new CoreException((IStatus)new Status(0, "org.eclipse.jst.jsf.facesconfig.ui.test", 0, ex.getMessage(), (Throwable)ex));
                }
                holder[0] = prj;
            }
        };
        ResourcesPlugin.getWorkspace().run(r, null);
        return holder[0];
    }

    public static void buildProject(IProject project, IProgressMonitor monitor) {
        try {
            project.build(6, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void expandZip(InputStream zipStream, IContainer dir) throws Exception {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(zipStream);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.isDirectory()) {
                    IFolder folder = dir.getFolder((IPath)new Path(ze.getName()));
                    if (!folder.exists()) {
                        TestUtil.ensurePath((IResource)folder);
                        folder.create(true, true, null);
                    }
                } else {
                    IFile file = dir.getFile((IPath)new Path(ze.getName()));
                    TestUtil.ensurePath((IResource)file);
                    if (file.exists()) {
                        file.setContents((InputStream)new ZipStreamWrapper(zis), 0, null);
                    } else {
                        file.create((InputStream)new ZipStreamWrapper(zis), true, null);
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (zis != null) {
                zis.close();
            }
        }
        catch (Exception exception) {}
    }

    private static void ensurePath(IResource file) throws CoreException {
        IContainer container = file.getParent();
        if (!container.exists()) {
            TestUtil.ensurePath((IResource)container);
            ((IFolder)container).create(true, true, null);
        }
    }

    public static IFile copyFile(IProject project, String targetPath, String sourcePath) throws Exception {
        URL url = FileLocator.find((Bundle)EditorPlugin.getDefault().getBundle(), (IPath)new Path(TEST_FILE_FOLDER + sourcePath), null);
        InputStream stream = url.openStream();
        IFile file = null;
        Path path = new Path(sourcePath);
        if (targetPath != null && targetPath.length() > 0) {
            IFolder folder = project.getFolder(targetPath);
            file = folder.getFile(path.lastSegment());
        } else {
            file = project.getFile(path.lastSegment());
        }
        if (!file.exists()) {
            TestUtil.ensurePath((IResource)file);
            file.create(stream, true, null);
        } else {
            file.setContents(stream, 1, null);
        }
        return file;
    }

    public static IFile createFile(IProject project, String filePath, String content) throws Exception {
        IFile file = project.getFile(filePath);
        TestUtil.ensurePath((IResource)file);
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)stream, true, null);
        return file;
    }

    public static String getFileAsString(String path) throws Exception {
        int count;
        URL url = FileLocator.find((Bundle)EditorPlugin.getDefault().getBundle(), (IPath)new Path(TEST_FILE_FOLDER + path), null);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer buffer = new StringBuffer();
        char[] temp = new char[256];
        while ((count = reader.read(temp)) > 0) {
            buffer.append(temp, 0, count);
        }
        reader.close();
        stream.close();
        return buffer.toString();
    }

    public static String removeAllWhitespace(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        int i = 0;
        int length = s.length();
        while (i < length) {
            if (!Character.isWhitespace(s.charAt(i))) {
                buffer.append(s.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void removeResource(final IResource prj) throws CoreException {
        if (prj instanceof IFile) {
            ((IFile)prj).delete(true, false, null);
            return;
        }
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                prj.delete(true, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(r, (ISchedulingRule)prj, 0, null);
    }

    public static boolean isValidJavaResource(IResource resource) {
        IMarker[] markers = JavaBuilder.getProblemsFor((IResource)resource);
        if (markers != null && markers.length > 0) {
            int i = 0;
            while (i < markers.length) {
                IMarker curr = markers[i];
                if (curr != null && curr.getAttribute("severity", -1) == 2) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

