/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.queue.EmptyQueue;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class EmptyQueueTests
extends TestCase {
    public EmptyQueueTests(String name) {
        super(name);
    }

    public void testEnqueue() {
        Queue queue = EmptyQueue.instance();
        boolean exCaught = false;
        try {
            queue.enqueue((Object)"junk");
            EmptyQueueTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyQueueTests.assertTrue((boolean)exCaught);
    }

    public void testDequeue() {
        Queue queue = EmptyQueue.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)queue.dequeue();
            EmptyQueueTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyQueueTests.assertTrue((boolean)exCaught);
    }

    public void testPeek() {
        Queue queue = EmptyQueue.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)queue.peek();
            EmptyQueueTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyQueueTests.assertTrue((boolean)exCaught);
    }

    public void testIsEmpty() {
        Queue queue = EmptyQueue.instance();
        EmptyQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testToString() {
        Queue queue = EmptyQueue.instance();
        EmptyQueueTests.assertEquals((String)"[]", (String)queue.toString());
    }

    public void testSerialization() throws Exception {
        Queue queue = EmptyQueue.instance();
        EmptyQueueTests.assertSame((Object)queue, (Object)TestTools.serialize(queue));
    }
}

