/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateManyToOneUniDirRelationFeature
extends CreateManyToOneRelationFeature
implements ICreateUniDirRelationFeature {
    public CreateManyToOneUniDirRelationFeature(IJPAEditorFeatureProvider fp, boolean isDerivedIdFeature) {
        super(fp, JPAEditorMessages.CreateManyToOneUniDirRelationFeature_manyToOneUniDirFeatureName, JPAEditorMessages.CreateManyToOneUniDirRelationFeature_manyToOneUniDirFeatureDescription, isDerivedIdFeature);
    }

    @Override
    public ManyToOneUniDirRelation createRelation(IJPAEditorFeatureProvider fp, PictogramElement source, PictogramElement target, PersistentType embeddingEntity) {
        String attributeName;
        PersistentType owner = (PersistentType)this.getBusinessObjectForPictogramElement(source);
        PersistentType inverse = (PersistentType)this.getBusinessObjectForPictogramElement(target);
        String nameWithNonCapitalLetter = attributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(inverse));
        if (JpaArtifactFactory.instance().isMethodAnnotated(owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(attributeName);
        }
        String attributeText = JPAEditorUtil.produceUniqueAttributeName(owner, nameWithNonCapitalLetter);
        ManyToOneUniDirRelation relation = new ManyToOneUniDirRelation(fp, owner, inverse, attributeText, true, this.isDerivedIdFeature);
        return relation;
    }

    public String getCreateImageId() {
        if (this.isDerivedIdFeature) {
            return "org.eclipse.jpt.jpadiagrameditor.ui.many_to_one_1_key_relation";
        }
        return "org.eclipse.jpt.jpadiagrameditor.ui.many_to_one_1_dir_relation";
    }

    @Override
    protected boolean isRelationshipPossible() {
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelsByEmbeddableWithEntity(this.owner, this.getFeatureProvider());
            if (refs.isEmpty()) {
                return false;
            }
            for (HasReferanceRelation ref : refs) {
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ref.getEmbeddedAnnotatedAttribute());
                if (!(attributeMapping instanceof EmbeddedIdMapping)) continue;
                return false;
            }
        }
        return true;
    }
}

