/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

abstract class TargetProvider {
    public static final boolean BUG_CORE_130317 = true;
    protected SourceProvider fSourceProvider;

    TargetProvider() {
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        Assert.isNotNull((Object)sourceProvider);
        this.fSourceProvider = sourceProvider;
    }

    public abstract void initialize();

    public abstract IJavaScriptUnit[] getAffectedCompilationUnits(RefactoringStatus var1, IProgressMonitor var2) throws JavaScriptModelException;

    public abstract BodyDeclaration[] getAffectedBodyDeclarations(IJavaScriptUnit var1, IProgressMonitor var2);

    public abstract ASTNode[] getInvocations(BodyDeclaration var1, IProgressMonitor var2);

    public abstract RefactoringStatus checkActivation() throws JavaScriptModelException;

    public abstract int getStatusSeverity();

    public boolean isSingle() {
        return false;
    }

    public static TargetProvider create(IJavaScriptUnit cu, FunctionInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(IJavaScriptUnit cu, SuperMethodInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(IJavaScriptUnit cu, ConstructorInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(FunctionDeclaration declaration) {
        IFunctionBinding method = declaration.resolveBinding();
        if (method == null) {
            return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_method_declaration_not_unique));
        }
        ITypeBinding type = method.getDeclaringClass();
        if (type.isLocal()) {
            if (((IType)type.getJavaElement()).isBinary()) {
                return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_cannot_local_method_in_binary));
            }
            IType declaringClassOfLocal = (IType)type.getDeclaringClass().getJavaElement();
            return new LocalTypeTargetProvider(declaringClassOfLocal.getJavaScriptUnit(), declaration);
        }
        return new MemberTypeTargetProvider(declaration.resolveBinding());
    }

    public static TargetProvider create(IFunctionBinding methodBinding) {
        return new MemberTypeTargetProvider(methodBinding);
    }

    static void fastDone(IProgressMonitor pm) {
        if (pm == null) {
            return;
        }
        pm.beginTask("", 1);
        pm.worked(1);
        pm.done();
    }

    private static class BodyData {
        public BodyDeclaration fBody;
        private List fInvocations;

        public BodyData(BodyDeclaration declaration) {
            this.fBody = declaration;
        }

        public void addInvocation(ASTNode node) {
            if (this.fInvocations == null) {
                this.fInvocations = new ArrayList(2);
            }
            this.fInvocations.add(node);
        }

        public ASTNode[] getInvocations() {
            return this.fInvocations.toArray(new ASTNode[this.fInvocations.size()]);
        }

        public boolean hasInvocations() {
            return this.fInvocations != null && !this.fInvocations.isEmpty();
        }

        public BodyDeclaration getDeclaration() {
            return this.fBody;
        }
    }

    static class ErrorTargetProvider
    extends TargetProvider {
        private RefactoringStatus fErrorStatus;

        public ErrorTargetProvider(RefactoringStatus status) {
            this.fErrorStatus = status;
        }

        @Override
        public RefactoringStatus checkActivation() throws JavaScriptModelException {
            return this.fErrorStatus;
        }

        @Override
        public void initialize() {
        }

        @Override
        public IJavaScriptUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) throws JavaScriptModelException {
            return null;
        }

        @Override
        public BodyDeclaration[] getAffectedBodyDeclarations(IJavaScriptUnit unit, IProgressMonitor pm) {
            return null;
        }

        @Override
        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            return null;
        }

        @Override
        public int getStatusSeverity() {
            return 0;
        }
    }

    private static class InvocationFinder
    extends ASTVisitor {
        Map result = new HashMap(2);
        Stack fBodies = new Stack();
        BodyData fCurrent;
        private IFunctionBinding fBinding;

        public InvocationFinder(IFunctionBinding binding) {
            Assert.isNotNull((Object)binding);
            this.fBinding = binding.getMethodDeclaration();
            Assert.isNotNull((Object)this.fBinding);
        }

        public boolean visit(FunctionInvocation node) {
            if (this.matches(node.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (this.matches(node.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ConstructorInvocation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType();
        }

        public void endVisit(TypeDeclaration node) {
            this.endVisitType();
        }

        private boolean visitType() {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = null;
            return true;
        }

        private void endVisitType() {
            this.fCurrent = (BodyData)this.fBodies.remove(this.fBodies.size() - 1);
        }

        public boolean visit(FieldDeclaration node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(FieldDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(FunctionDeclaration node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(FunctionDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(Initializer node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(Initializer node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        private boolean matches(IBinding binding) {
            if (!(binding instanceof IFunctionBinding)) {
                return false;
            }
            return this.fBinding.getKey().equals(((IFunctionBinding)binding).getMethodDeclaration().getKey());
        }
    }

    private static class LocalTypeTargetProvider
    extends TargetProvider {
        private IJavaScriptUnit fCUnit;
        private FunctionDeclaration fDeclaration;
        private Map fBodies;

        public LocalTypeTargetProvider(IJavaScriptUnit unit, FunctionDeclaration declaration) {
            Assert.isNotNull((Object)unit);
            Assert.isNotNull((Object)declaration);
            this.fCUnit = unit;
            this.fDeclaration = declaration;
        }

        @Override
        public void initialize() {
            InvocationFinder finder = new InvocationFinder(this.fDeclaration.resolveBinding());
            ASTNode type = ASTNodes.getParent((ASTNode)this.fDeclaration, AbstractTypeDeclaration.class);
            type.accept((ASTVisitor)finder);
            this.fBodies = finder.result;
        }

        @Override
        public IJavaScriptUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) {
            LocalTypeTargetProvider.fastDone(pm);
            return new IJavaScriptUnit[]{this.fCUnit};
        }

        @Override
        public BodyDeclaration[] getAffectedBodyDeclarations(IJavaScriptUnit unit, IProgressMonitor pm) {
            Assert.isTrue((unit == this.fCUnit ? 1 : 0) != 0);
            Set result = this.fBodies.keySet();
            LocalTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        @Override
        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = (BodyData)this.fBodies.get(declaration);
            Assert.isNotNull((Object)data);
            LocalTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        @Override
        public RefactoringStatus checkActivation() throws JavaScriptModelException {
            return new RefactoringStatus();
        }

        @Override
        public int getStatusSeverity() {
            return 3;
        }
    }

    private static class MemberTypeTargetProvider
    extends TargetProvider {
        private final IFunctionBinding fMethodBinding;
        private Map fCurrentBodies;

        public MemberTypeTargetProvider(IFunctionBinding methodBinding) {
            Assert.isNotNull((Object)methodBinding);
            this.fMethodBinding = methodBinding;
        }

        @Override
        public void initialize() {
        }

        @Override
        public IJavaScriptUnit[] getAffectedCompilationUnits(final RefactoringStatus status, IProgressMonitor pm) throws JavaScriptModelException {
            IFunction method = (IFunction)this.fMethodBinding.getJavaElement();
            Assert.isTrue((method != null ? 1 : 0) != 0);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)method, (int)2, (int)24));
            engine.setGranularity(2);
            engine.setFiltering(true, true);
            engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)method));
            engine.setRequestor(new IRefactoringSearchRequestor(){

                @Override
                public SearchMatch acceptSearchMatch(SearchMatch match) {
                    if (match.isInsideDocComment()) {
                        return null;
                    }
                    if (match.getAccuracy() == 1) {
                        IJavaScriptElement jElement;
                        IJavaScriptUnit unit;
                        Object element = match.getElement();
                        if (element instanceof IJavaScriptElement && (unit = (IJavaScriptUnit)(jElement = (IJavaScriptElement)element).getAncestor(5)) != null) {
                            status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match, JavaStatusContext.create((ITypeRoot)unit, new SourceRange(match.getOffset(), match.getLength())));
                            return null;
                        }
                        status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match);
                        return null;
                    }
                    return match;
                }
            });
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return engine.getAffectedCompilationUnits();
        }

        @Override
        public BodyDeclaration[] getAffectedBodyDeclarations(IJavaScriptUnit unit, IProgressMonitor pm) {
            JavaScriptUnit root = new RefactoringASTParser(3).parse((ITypeRoot)unit, true);
            InvocationFinder finder = new InvocationFinder(this.fMethodBinding);
            root.accept((ASTVisitor)finder);
            this.fCurrentBodies = finder.result;
            Set result = this.fCurrentBodies.keySet();
            MemberTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        @Override
        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = (BodyData)this.fCurrentBodies.get(declaration);
            Assert.isNotNull((Object)data);
            MemberTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        @Override
        public RefactoringStatus checkActivation() throws JavaScriptModelException {
            return new RefactoringStatus();
        }

        @Override
        public int getStatusSeverity() {
            return 3;
        }
    }

    static class SingleCallTargetProvider
    extends TargetProvider {
        private IJavaScriptUnit fCUnit;
        private ASTNode fInvocation;
        private boolean fIterated;

        public SingleCallTargetProvider(IJavaScriptUnit cu, ASTNode invocation) {
            Assert.isNotNull((Object)cu);
            Assert.isNotNull((Object)invocation);
            Assert.isTrue((boolean)Invocations.isInvocation(invocation));
            this.fCUnit = cu;
            this.fInvocation = invocation;
        }

        @Override
        public void initialize() {
            this.fIterated = false;
        }

        @Override
        public IJavaScriptUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) {
            return new IJavaScriptUnit[]{this.fCUnit};
        }

        @Override
        public BodyDeclaration[] getAffectedBodyDeclarations(IJavaScriptUnit unit, IProgressMonitor pm) {
            Assert.isTrue((unit == this.fCUnit ? 1 : 0) != 0);
            if (this.fIterated) {
                return new BodyDeclaration[0];
            }
            SingleCallTargetProvider.fastDone(pm);
            return new BodyDeclaration[]{(BodyDeclaration)ASTNodes.getParent(this.fInvocation, BodyDeclaration.class)};
        }

        @Override
        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            SingleCallTargetProvider.fastDone(pm);
            if (this.fIterated) {
                return null;
            }
            this.fIterated = true;
            return new ASTNode[]{this.fInvocation};
        }

        @Override
        public RefactoringStatus checkActivation() throws JavaScriptModelException {
            return new RefactoringStatus();
        }

        @Override
        public int getStatusSeverity() {
            return 4;
        }

        @Override
        public boolean isSingle() {
            return true;
        }
    }
}

