/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class EqualsTests
extends TestCase {
    private Predicate<Integer> equalPredicate;

    public EqualsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.equalPredicate = PredicateTools.isEqual((Object)42);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate() {
        EqualsTests.assertTrue((boolean)this.equalPredicate.evaluate((Object)new Integer(42)));
        EqualsTests.assertTrue((boolean)this.equalPredicate.evaluate((Object)42));
        EqualsTests.assertTrue((boolean)this.equalPredicate.evaluate((Object)Integer.valueOf("42")));
        EqualsTests.assertFalse((boolean)this.equalPredicate.evaluate(null));
        EqualsTests.assertFalse((boolean)this.equalPredicate.evaluate((Object)24));
    }

    public void testEquals() {
        Predicate equalPredicate2 = PredicateTools.isEqual((Object)new Integer(42));
        EqualsTests.assertEquals(this.equalPredicate, (Object)equalPredicate2);
        EqualsTests.assertEquals((int)this.equalPredicate.hashCode(), (int)equalPredicate2.hashCode());
        EqualsTests.assertFalse((boolean)this.equalPredicate.equals((Object)IsNotNull.instance()));
    }
}

