/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaAttributesContainer
extends AbstractJavaContextNode
implements JaxbAttributesContainer<JavaPersistentAttribute> {
    protected JavaResourceType javaResourceType;
    protected JaxbAttributesContainer.Context owner;
    protected final Vector<JavaPersistentAttribute> attributes = new Vector();

    public GenericJavaAttributesContainer(JaxbClassMapping parent, JaxbAttributesContainer.Context owner, JavaResourceType resourceType) {
        super(parent);
        this.javaResourceType = resourceType;
        this.owner = owner;
        this.initializeAttributes();
    }

    public JaxbClassMapping getClassMapping() {
        return (JaxbClassMapping)this.getParent();
    }

    public boolean isFor(JavaResourceType jrt) {
        return this.javaResourceType == jrt;
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.synchronizeNodesWithResourceModel(this.getAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.updateAttributes();
    }

    protected XmlAccessType getAccessType() {
        return this.owner.getAccessType();
    }

    @Override
    public Iterable<JavaPersistentAttribute> getAttributes() {
        return IterableTools.cloneLive(this.attributes);
    }

    @Override
    public int getAttributesSize() {
        return this.attributes.size();
    }

    protected void addAttribute(JavaPersistentAttribute attribute) {
        if (this.attributes.add(attribute)) {
            this.owner.attributeAdded(attribute);
        }
    }

    protected void removeAttribute(JavaPersistentAttribute attribute) {
        if (this.attributes.remove(attribute)) {
            this.owner.attributeRemoved(attribute);
        }
    }

    protected JavaPersistentAttribute buildField(JavaResourceField resourceField) {
        return this.getFactory().buildJavaPersistentField(this.getClassMapping(), resourceField);
    }

    protected JavaPersistentAttribute buildProperty(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.getFactory().buildJavaPersistentProperty(this.getClassMapping(), resourceGetter, resourceSetter);
    }

    protected void initializeAttributes() {
        if (this.getClassMapping().isXmlTransient()) {
            return;
        }
        if (this.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            this.initializePublicMemberAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.FIELD) {
            this.intializeFieldAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.PROPERTY) {
            this.intializePropertyAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.NONE) {
            this.intializeNoneAccessAttributes();
        }
    }

    private void initializePublicMemberAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_PUBLIC_MEMBER_ACCESS);
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (this.includePublicMemberAccessProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void intializeFieldAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_FIELD_ACCESS);
        this.initializeAnnotatedPropertyAttributes();
    }

    private void intializePropertyAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (this.includeProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void intializeNoneAccessAttributes() {
        this.initializeFieldAttributes((Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        this.initializeAnnotatedPropertyAttributes();
    }

    private void initializeFieldAttributes(Predicate<? super JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            this.attributes.add(this.buildField(resourceField));
        }
    }

    private void initializeRemainingResourceMethodAttributes(Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            this.attributes.add(this.buildProperty(null, resourceMethod));
        }
    }

    private boolean includeProperty(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return setterMethod != null || getterMethod.getTypeBinding().getQualifiedName().equals(List.class.getName()) || getterMethod.isAnnotated();
    }

    private boolean includePublicMemberAccessProperty(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        if (getterMethod.isPublic()) {
            if (setterMethod != null) {
                if (setterMethod.isPublic()) {
                    return true;
                }
            } else {
                if (getterMethod.getTypeBinding().getQualifiedName().equals(List.class.getName())) {
                    return true;
                }
                if (getterMethod.isAnnotated()) {
                    return true;
                }
            }
        } else if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
            return true;
        }
        return false;
    }

    private void initializeAnnotatedPropertyAttributes() {
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    protected Iterable<JavaResourceField> getResourceFields() {
        return this.javaResourceType.getFields();
    }

    protected Iterable<JavaResourceMethod> getResourceMethods() {
        return this.javaResourceType.getMethods();
    }

    protected Iterable<JavaResourceField> getResourceFields(Predicate<? super JavaResourceField> filter) {
        return IterableTools.filter(this.getResourceFields(), filter);
    }

    protected Iterable<JavaResourceMethod> filterResourceMethods(Predicate<JavaResourceMethod> filter) {
        return IterableTools.filter(this.getResourceMethods(), filter);
    }

    protected Iterable<JavaResourceMethod> getResourcePropertyGetters() {
        return this.filterResourceMethods((Predicate<JavaResourceMethod>)JavaResourceMethod.IS_PROPERTY_GETTER);
    }

    protected void updateAttributes() {
        if (this.getClassMapping().isXmlTransient()) {
            for (JavaPersistentAttribute contextAttribute : this.getAttributes()) {
                this.removeAttribute(contextAttribute);
            }
            return;
        }
        if (this.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            this.syncPublicMemberAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.FIELD) {
            this.syncFieldAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.PROPERTY) {
            this.syncPropertyAccessAttributes();
        } else if (this.getAccessType() == XmlAccessType.NONE) {
            this.syncNoneAccessAttributes();
        }
    }

    private void syncPublicMemberAccessAttributes() {
        HashSet contextAttributes = CollectionTools.hashSet(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_PUBLIC_MEMBER_ACCESS);
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (!this.includePublicMemberAccessProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) continue;
            boolean match = false;
            Iterator stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaPersistentAttribute contextAttribute = (JavaPersistentAttribute)stream.next();
                if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (!match) {
                this.addAttribute(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAccessAttributes() {
        HashSet contextAttributes = CollectionTools.hashSet(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceField.IS_RELEVANT_FOR_FIELD_ACCESS);
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncPropertyAccessAttributes() {
        HashSet contextAttributes = CollectionTools.hashSet(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod;
            if (this.includeProperty(getterMethod, setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod))) {
                boolean match = false;
                Iterator stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaPersistentAttribute contextAttribute = (JavaPersistentAttribute)stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncNoneAccessAttributes() {
        HashSet contextAttributes = CollectionTools.hashSet(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, (Predicate<? super JavaResourceField>)JavaResourceAnnotatedElement.IS_ANNOTATED);
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncAnnotatedPropertyAttributes(HashSet<JavaPersistentAttribute> contextAttributes) {
        HashBag resourceMethods = CollectionTools.hashBag(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourcePropertyGetters()) {
            JavaResourceMethod setterMethod = (JavaResourceMethod)JavaResourceMethod.SET_METHOD_TRANSFORMER.transform((Object)getterMethod);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                boolean match = false;
                Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaPersistentAttribute contextAttribute = stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAttributes(HashSet<JavaPersistentAttribute> contextAttributes, Predicate<? super JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            boolean match = false;
            Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(resourceField)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.buildField(resourceField));
        }
    }

    private void syncRemainingResourceMethods(HashSet<JavaPersistentAttribute> contextAttributes, Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            boolean match = false;
            Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(null, resourceMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.buildProperty(null, resourceMethod));
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributes) {
            this.removeAttribute(contextAttribute);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            jaxbPersistentAttribute.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getClassMapping().getValidationTextRange();
    }
}

