/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel;

import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.favorites.FavoritesRegistryTypeWSE;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesUDDIRegistryFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;

public class FavoritesMainElement
extends TreeElement {
    private Controller controller_;
    private FavoritesRegistryTypeWSE favRegistry_;

    public FavoritesMainElement(String name, Model model, Controller controller) {
        super(name, model);
        this.controller_ = controller;
        this.favRegistry_ = new FavoritesRegistryTypeWSE(controller.getDefaultFavoritesLocation(), controller.getServletEngineStateLocation());
    }

    public boolean restoreFavoritesDefault() {
        this.favRegistry_.restoreFavoritesDefault();
        return this.saveFavorites();
    }

    public boolean saveFavorites() {
        try {
            this.favRegistry_.save();
            return true;
        }
        catch (Throwable throwable) {
            FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
            favPerspective.getMessageQueue().addMessage(favPerspective.getMessage("MSG_ERROR_SAVE_FAVORITES_WSIL", this.favRegistry_.getWriteLocation()));
            return false;
        }
    }

    public Link addUDDIRegistry(String registryName, String inquiryAPI, String publishAPI, String registrationURL) {
        return this.favRegistry_.addUDDIRegistry(registryName, inquiryAPI, publishAPI, registrationURL);
    }

    public Link addUDDIBusiness(String businessName, String inquiryAPI, String businessKey) {
        return this.favRegistry_.addUDDIBusiness(businessName, inquiryAPI, businessKey);
    }

    public Service addUDDIService(String serviceName, String inquiryAPI, String serviceKey) {
        return this.favRegistry_.addUDDIService(serviceName, inquiryAPI, serviceKey);
    }

    public Service addUDDIServiceInterface(String serIntName, String inquiryAPI, String serIntKey) {
        return this.favRegistry_.addUDDIServiceInterface(serIntName, inquiryAPI, serIntKey);
    }

    public Service addWSDLService(String url) {
        return this.favRegistry_.addWSDLService(url);
    }

    public Link addWSILLink(String url) {
        return this.favRegistry_.addWSILLink(url);
    }

    public boolean removeService(Service service) {
        this.favRegistry_.removeService(service);
        return true;
    }

    public boolean removeLink(Link link) {
        this.favRegistry_.removeLink(link);
        return true;
    }

    public Link[] loadUDDIRegistries() {
        return this.favRegistry_.loadUDDIRegistries();
    }

    public Link[] loadUDDIBusinesses() {
        return this.favRegistry_.loadUDDIBusinesses();
    }

    public Service[] loadUDDIServices() {
        return this.favRegistry_.loadUDDIServices();
    }

    public Service[] loadUDDIServiceInterfaces() {
        return this.favRegistry_.loadUDDIServiceInterfaces();
    }

    public Service[] loadWSDLServices() {
        return this.favRegistry_.loadWSDLServices();
    }

    public Link[] loadWSILs() {
        return this.favRegistry_.loadWSILs();
    }

    public final FavoritesUDDIRegistryFolderElement getFavoritesUDDIRegistryFolderElement() {
        return (FavoritesUDDIRegistryFolderElement)((Object)this.getElements("relUDDIRegistryFolerNode").nextElement());
    }
}

