/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class GotoAnnotationAction
extends TextEditorAction {
    private static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/gotoNextAnnotation"));
    private boolean fForward;
    private String fLabel;
    private String fPrefix;

    public GotoAnnotationAction(String prefix, boolean forward) {
        super(SSEUIMessages.getResourceBundle(), prefix, null);
        this.fForward = forward;
        this.fPrefix = prefix;
        this.fLabel = SSEUIMessages.getResourceBundle().getString(this.fPrefix);
    }

    public String getDefaultLabel() {
        return this.fLabel;
    }

    public String getDescription() {
        return this.getDefaultLabel();
    }

    protected Annotation getNextAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getTextEditor().getDocumentProvider().getAnnotationModel((Object)this.getTextEditor().getEditorInput());
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                Position p;
                Annotation a = (Annotation)e.next();
                if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
                if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                    if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                    containingAnnotation = a;
                    containingAnnotationPosition = p;
                    currentAnnotation = p.length == length;
                    continue;
                }
                int currentDistance = 0;
                if (forward) {
                    currentDistance = p.getOffset() - offset;
                    if (currentDistance < 0) {
                        currentDistance = endOfDocument + currentDistance;
                    }
                    if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                    distance = currentDistance;
                    nextAnnotation = a;
                    nextAnnotationPosition = p;
                    continue;
                }
                currentDistance = offset + length - (p.getOffset() + p.length);
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
            }
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private IStatusLineManager getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorActionBarContributor contributor = editor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public String getText() {
        return this.getDefaultLabel();
    }

    public String getToolTipText() {
        return this.getDefaultLabel();
    }

    public void gotoAnnotation(boolean forward) {
        IStatusLineManager mgr;
        ITextSelection selection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        Annotation annotation = this.getNextAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        IEditorStatusLine editorStatusLine = (IEditorStatusLine)this.getTextEditor().getAdapter(IEditorStatusLine.class);
        if (editorStatusLine != null) {
            editorStatusLine.setMessage(true, null, null);
            editorStatusLine.setMessage(false, null, null);
        } else {
            mgr = this.getStatusLineManager();
            if (mgr != null) {
                mgr.setErrorMessage(null);
                mgr.setMessage(null, null);
            }
        }
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            if (_debug) {
                System.out.println("select and reveal " + annotation.getType() + "@" + position.getOffset() + ":" + position.getLength());
            }
            this.getTextEditor().selectAndReveal(position.getOffset(), position.getLength());
            if (editorStatusLine != null) {
                editorStatusLine.setMessage(true, null, null);
                editorStatusLine.setMessage(false, annotation.getText(), null);
            } else {
                mgr = this.getStatusLineManager();
                if (mgr != null) {
                    mgr.setErrorMessage(null);
                    mgr.setMessage(null, annotation.getText());
                }
                this.getTextEditor().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)new StatusLineClearer(mgr));
            }
        }
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        Preferences preferences = EditorsUI.getPluginPreferences();
        AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && preferences.getBoolean(key);
    }

    public void run() {
        this.gotoAnnotation(this.fForward);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.update();
    }

    protected void updateAnnotationViews(Annotation annotation) {
        IMarker marker = null;
        if (annotation instanceof SimpleMarkerAnnotation) {
            marker = ((SimpleMarkerAnnotation)annotation).getMarker();
        }
        if (marker != null) {
            try {
                IWorkbenchPage page;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    Method method;
                    IViewPart view = null;
                    if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        view = page.findView("org.eclipse.ui.views.ProblemView");
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                        view = page.findView("org.eclipse.ui.views.TaskList");
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                        view = page.findView("org.eclipse.ui.views.BookmarkView");
                    }
                    if (view == null) {
                        view = page.findView("org.eclipse.ui.views.AllMarkersView");
                    }
                    if (view != null && (method = view.getClass().getMethod("setSelection", IStructuredSelection.class, Boolean.TYPE)) != null) {
                        method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                        page.bringToTop((IWorkbenchPart)view);
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    protected class StatusLineClearer
    implements ISelectionChangedListener {
        IStatusLineManager fStatusLineManager = null;

        protected StatusLineClearer(IStatusLineManager mgr) {
            this.fStatusLineManager = mgr;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GotoAnnotationAction.this.getTextEditor().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            this.fStatusLineManager.setErrorMessage(null, null);
            this.fStatusLineManager.setMessage(null, null);
        }
    }
}

