/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.ecore.resource.impl;

import java.util.List;
import java.util.Map;
import org.apache.axis.model.common.util.BasicEList;
import org.apache.axis.model.common.util.BasicEMap;
import org.apache.axis.model.common.util.URI;
import org.apache.axis.model.ecore.resource.impl.URIConverterImpl;

public class URIMappingRegistryImpl
extends BasicEMap {
    public static final URIMappingRegistryImpl INSTANCE = new URIMappingRegistryImpl();
    protected BasicEList prefixMaps = new BasicEList();

    protected BasicEMap.Entry newEntry(int hash, Object key, Object value) {
        this.validateKey(key);
        this.validateValue(value);
        return new MappingEntryImpl(hash, key, value);
    }

    public URI getURI(URI uri) {
        URI result = (URI)this.get(uri);
        if (result == null) {
            if (this.prefixMaps != null) {
                int i = Math.min(this.prefixMaps.size() - 1, uri.segmentCount());
                while (i >= 0) {
                    List prefixes = (List)this.prefixMaps.get(i);
                    int j = prefixes.size() - 1;
                    while (j >= 0) {
                        BasicEMap.Entry entry = (BasicEMap.Entry)prefixes.get(j);
                        result = uri.replacePrefix((URI)entry.getKey(), (URI)entry.getValue());
                        if (result != null) {
                            return result;
                        }
                        --j;
                    }
                    --i;
                }
            }
            result = this.delegatedGetURI(uri);
        }
        return result;
    }

    protected URI delegatedGetURI(URI uri) {
        return uri;
    }

    public Map map() {
        if (this.view == null) {
            this.view = new BasicEMap.View();
        }
        if (this.view.map == null) {
            this.view.map = new URIMapImpl();
        }
        return this.view.map;
    }

    protected void validateKey(Object key) {
        if (!(key instanceof URI)) {
            throw new IllegalArgumentException();
        }
    }

    protected void validateValue(Object value) {
        if (!(value instanceof URI)) {
            throw new IllegalArgumentException();
        }
    }

    protected void didAdd(BasicEMap.Entry entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int length = ((URI)entry.getKey()).segmentCount();
            if (this.prefixMaps == null) {
                this.prefixMaps = new BasicEList();
            }
            int i = this.prefixMaps.size() - 1;
            while (i <= length) {
                this.prefixMaps.add(new BasicEList());
                ++i;
            }
            ((List)this.prefixMaps.get(length)).add(entry);
        }
    }

    protected void didModify(BasicEMap.Entry entry, Object oldValue) {
        this.didRemove(entry);
        ((MappingEntryImpl)entry).determineEntryType();
        this.didAdd(entry);
    }

    protected void didRemove(BasicEMap.Entry entry) {
        if (((MappingEntryImpl)entry).isPrefixMapEntry) {
            int length = ((URI)entry.getKey()).segmentCount();
            ((List)this.prefixMaps.get(length)).remove(entry);
        }
    }

    protected void didClear(BasicEList[] oldEntryData) {
        this.prefixMaps = null;
    }

    protected class MappingEntryImpl
    extends BasicEMap.EntryImpl {
        public boolean isPrefixMapEntry;

        public MappingEntryImpl(int hash, Object key, Object value) {
            super(hash, key, value);
            this.determineEntryType();
        }

        public void determineEntryType() {
            this.isPrefixMapEntry = ((URI)this.key).isPrefix() && ((URI)this.value).isPrefix();
        }
    }

    protected class URIMapImpl
    extends BasicEMap.DelegatingMap
    implements URIConverterImpl.URIMap {
        public URI getURI(URI uri) {
            return URIMappingRegistryImpl.this.getURI(uri);
        }
    }
}

