/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.junit4;

import java.io.File;
import java.lang.reflect.Field;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.junit4.RealWorkspaceContext;
import org.eclipse.jst.jsf.test.util.junit4.TestDataBaseLocation;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;

public class WorkspaceRunner
extends BlockJUnit4ClassRunner {
    @Rule
    public MethodRule rule = new WorkspaceContextInjector();

    public WorkspaceRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static interface IWorkspaceContextFactory {
        public IWorkspaceContext createContext();
    }

    public static class WorkspaceContextInjector
    implements MethodRule {
        protected IWorkspaceContext before(FrameworkMethod method, Object target) throws Throwable {
            Class<?> declaringClass = method.getMethod().getDeclaringClass();
            ClassLoader classLoader = declaringClass.getClassLoader();
            Field[] declaredFields = declaringClass.getDeclaredFields();
            IWorkspaceContextWithEvents context = Platform.isRunning() ? new RealWorkspaceContext() : new MockWorkspaceContext();
            context.init();
            File baseLoc = null;
            if (Platform.isRunning() && classLoader instanceof ModuleClassLoader) {
                Bundle bundle = ((ModuleClassLoader)classLoader).getBundle();
                IPath absolutePath = JSFTestUtil.getAbsolutePath(bundle, "/");
                baseLoc = absolutePath.toFile();
            } else {
                baseLoc = new File(".").getAbsoluteFile();
            }
            Assert.assertTrue((boolean)baseLoc.isDirectory());
            Field[] fieldArray = declaredFields;
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                TestDataBaseLocation locAnnotation;
                Field field = fieldArray[n2];
                WorkspaceContext annotation = field.getAnnotation(WorkspaceContext.class);
                if (annotation != null) {
                    field.setAccessible(true);
                    field.set(target, context);
                }
                if ((locAnnotation = field.getAnnotation(TestDataBaseLocation.class)) != null) {
                    field.setAccessible(true);
                    field.set(target, baseLoc);
                }
                ++n2;
            }
            return context;
        }

        protected void after(IWorkspaceContext context) throws Exception {
            context.dispose();
        }

        public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    IWorkspaceContext context = this.before(method, target);
                    try {
                        base.evaluate();
                    }
                    finally {
                        this.after(context);
                    }
                }
            };
        }
    }
}

