/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.nav;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.nav.ICaretPositionMover;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingNavigationMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;

public class HorizontalMoveCommand
extends Command
implements ICaretPositionMover {
    private static Logger _log = PDPlugin.getLogger(HorizontalMoveCommand.class);
    IHTMLGraphicalViewer _viewer;
    boolean _forward;
    boolean _onlyMoveEnd;

    public HorizontalMoveCommand(IHTMLGraphicalViewer viewer, boolean b, boolean c) {
        this._viewer = viewer;
        this._forward = b;
        this._onlyMoveEnd = c;
    }

    public void execute() {
        DesignPosition position = null;
        if (this._viewer.isInRangeMode()) {
            if (this._viewer.getRangeSelection() != null && this._viewer.getRangeSelection().isValid()) {
                position = this._viewer.getRangeSelection().getEndPosition();
                position = this.performInlineMode(this._forward);
            }
        } else {
            position = this.performObjectMode();
        }
        this.setRange(position);
    }

    private DesignPosition performObjectMode() {
        DesignPosition result = null;
        InlineEditingNavigationMediator validator = new InlineEditingNavigationMediator(new ActionData(4, null));
        DesignPosition position = this.getCurrentObjectPosition();
        if (position != null) {
            this._viewer.setRange(position, position);
            result = !validator.isValidPosition(position) ? (validator.isValidPosition(position = this.performInlineMode(this._forward)) ? position : this.performInlineMode(!this._forward)) : position;
        }
        return result;
    }

    private DesignPosition performInlineMode(boolean forward) {
        DesignRange range = this._viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            _log.error("invalid range");
            return null;
        }
        DesignPosition position = range.getEndPosition();
        if (position.getContainerPart() instanceof TextEditPart) {
            int length = ((TextEditPart)position.getContainerPart()).getTextData().length();
            int newoffset = position.getOffset() + (this._forward ? 1 : -1);
            if (newoffset >= 0 && newoffset <= length) {
                DesignPosition newposi = new DesignPosition(position.getContainerPart(), newoffset);
                return newposi;
            }
        }
        DesignPosition newpos = EditHelper.moveToNextEditPosition(4, position, forward);
        return newpos;
    }

    private void setRange(DesignPosition newpos) {
        if (this._onlyMoveEnd) {
            this._viewer.setRangeEndPosition(newpos);
        } else {
            this._viewer.setRange(newpos, newpos);
        }
    }

    private DesignPosition getCurrentObjectPosition() {
        DesignRange result = null;
        if (this._viewer.isInRangeMode()) {
            result = this._viewer.getRangeSelection();
        } else {
            EditPart selection;
            List parts = this._viewer.getSelectedEditParts();
            if (parts.size() > 0 && (selection = (EditPart)parts.get(0)) instanceof SubNodeEditPart) {
                DesignRefPosition position = new DesignRefPosition(selection, this._forward);
                result = new DesignRange(position, position);
            }
        }
        return result != null && result.isValid() ? result.getEndPosition() : null;
    }
}

