/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IPolicyStateEnum;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class ServicePolicyHelper {
    public static IServicePolicy getActivePolicyWithProtocol(IProject project) {
        IServicePolicy thePolicy = null;
        IServicePolicy[] policies = ServicePolicyHelper.getActiveServicePolicies(project);
        int i = 0;
        while (i < policies.length) {
            String defaultBinding;
            IServicePolicy policy = policies[i];
            IPolicyState policyState = policy.getPolicyState(project);
            if (policyState != null && (defaultBinding = policyState.getValue("defaultProtocol")) != null && defaultBinding.length() > 0) {
                thePolicy = policy;
                IPolicyStateEnum policyStateEnum = policy.getPolicyStateEnum(project);
                String enumId = policyStateEnum.getCurrentItem().getId();
                if ("org.eclipse.wst.sug.require".equals(enumId)) break;
            }
            ++i;
        }
        return thePolicy;
    }

    public static String getDefaultBinding(IProject project) {
        String defaultBinding = null;
        IServicePolicy policy = ServicePolicyHelper.getActivePolicyWithProtocol(project);
        if (policy != null) {
            defaultBinding = policy.getPolicyState(project).getValue("defaultProtocol");
        }
        if (defaultBinding == null) {
            defaultBinding = ServicePolicyHelper.getDefaultDefaultBinding();
        }
        return defaultBinding;
    }

    public static String getDefaultBinding(IProject project, IServicePolicy policy) {
        String defaultBinding = null;
        if (policy != null) {
            defaultBinding = policy.getPolicyState(project).getValue("defaultProtocol");
        }
        if (defaultBinding == null) {
            defaultBinding = ServicePolicyHelper.getDefaultDefaultBinding();
        }
        return defaultBinding;
    }

    public static int getMessageSeverity(IProject project, IServicePolicy policy) {
        int messageSeverity = 0;
        if (policy != null) {
            IPolicyStateEnum policyStateEnum = policy.getPolicyStateEnum(project);
            String enumId = policyStateEnum.getCurrentItem().getId();
            if ("org.eclipse.wst.sug.require".equals(enumId)) {
                messageSeverity = 3;
            } else if ("org.eclipse.wst.sug.suggest".equals(enumId)) {
                messageSeverity = 2;
            }
        }
        return messageSeverity;
    }

    private static String getDefaultDefaultBinding() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    private static IServicePolicy[] getActiveServicePolicies(IProject project) {
        ArrayList<IServicePolicy> servicePolicies = new ArrayList<IServicePolicy>();
        IServicePolicy rootPolicy = ServicePolicyPlatform.getInstance().getServicePolicy("org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp");
        if (rootPolicy != null) {
            List wsiPolicies = rootPolicy.getChildren();
            int i = 0;
            while (i < wsiPolicies.size()) {
                IServicePolicy policy = (IServicePolicy)wsiPolicies.get(i);
                IPolicyStateEnum policyStateEnum = policy.getPolicyStateEnum(project);
                String enumId = policyStateEnum.getCurrentItem().getId();
                if (("org.eclipse.wst.sug.require".equals(enumId) || "org.eclipse.wst.sug.suggest".equals(enumId)) && !"org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsiap".equals(policy.getId())) {
                    servicePolicies.add(policy);
                }
                ++i;
            }
        }
        return servicePolicies.toArray(new IServicePolicy[servicePolicies.size()]);
    }
}

