/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Document;

public class FnCollection
extends Function {
    private static Collection _expected_args = null;
    public static final String DEFAULT_COLLECTION_URI = "http://www.w3.org/2005/xpath-functions/collection/default";

    public FnCollection() {
        super(new QName("collection"), 0, 1);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnCollection.collection(args, ec);
    }

    public static ResultSequence collection(Collection args, EvaluationContext ec) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnCollection.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = null;
        String uri = DEFAULT_COLLECTION_URI;
        if (argiter.hasNext()) {
            arg1 = (ResultSequence)argiter.next();
            uri = ((XSString)arg1.first()).value();
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw DynamicError.doc_not_found(null);
        }
        if (uri.indexOf(":") < 0) {
            throw DynamicError.invalidCollectionArgument();
        }
        URI resolved = ec.getDynamicContext().resolveUri(uri);
        if (resolved == null) {
            throw DynamicError.invalid_doc(null);
        }
        ResultSequence rs = FnCollection.getCollection(uri, ec);
        if (rs.empty()) {
            throw DynamicError.doc_not_found(null);
        }
        return rs;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
        }
        return _expected_args;
    }

    private static ResultSequence getCollection(String uri, EvaluationContext ec) {
        ResultBuffer rs = new ResultBuffer();
        Map<String, List<Document>> collectionMap = ec.getDynamicContext().getCollections();
        List<Document> docList = collectionMap.get(uri);
        int i = 0;
        while (i < docList.size()) {
            Document doc = docList.get(i);
            rs.add(new DocType(doc, ec.getStaticContext().getTypeModel()));
            ++i;
        }
        return rs.getSequence();
    }
}

