/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.platform.InternalJpaPlatformUiManager;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

public class InternalJpaWorkbench
implements JpaWorkbench {
    private final IWorkbench workbench;
    private final JpaWorkspace jpaWorkspace;
    private final InternalJpaPlatformUiManager jpaPlatformUiManager;
    private volatile JpaSelectionManager jpaSelectionManager;
    private final ResourceManager resourceManager;
    private static final String RESOURCE_MANAGER_KEY = String.valueOf(JptJpaUiPlugin.instance().getPluginID()) + ".ResourceManager";

    public InternalJpaWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
        this.jpaWorkspace = this.buildJpaWorkspace();
        this.jpaPlatformUiManager = this.buildJpaPlatformUiManager();
        this.resourceManager = this.buildResourceManager();
    }

    @Override
    public JpaWorkspace getJpaWorkspace() {
        return this.jpaWorkspace;
    }

    private JpaWorkspace buildJpaWorkspace() {
        return (JpaWorkspace)this.getWorkspace().getAdapter(JpaWorkspace.class);
    }

    @Override
    public InternalJpaPlatformUiManager getJpaPlatformUiManager() {
        return this.jpaPlatformUiManager;
    }

    private InternalJpaPlatformUiManager buildJpaPlatformUiManager() {
        return new InternalJpaPlatformUiManager(this);
    }

    public JpaSelectionManager getJpaSelectionManager() {
        return this.jpaSelectionManager;
    }

    public void setJpaSelectionManager(JpaSelectionManager jpaSelectionManager) {
        this.jpaSelectionManager = jpaSelectionManager;
    }

    @Override
    public ResourceManager buildLocalResourceManager() {
        return new LocalResourceManager(this.resourceManager);
    }

    @Override
    public synchronized ResourceManager getResourceManager(Control control) {
        ResourceManager controlRM = (ResourceManager)control.getData(RESOURCE_MANAGER_KEY);
        if (controlRM == null) {
            controlRM = new LocalResourceManager(this.resourceManager, control);
            control.setData(RESOURCE_MANAGER_KEY, (Object)controlRM);
        }
        return controlRM;
    }

    private ResourceManager buildResourceManager() {
        return new LocalResourceManager(this.getParentResourceManager());
    }

    private ResourceManager getParentResourceManager() {
        return JFaceResources.getResources((Display)this.getDisplay());
    }

    private Display getDisplay() {
        return this.workbench.getDisplay();
    }

    @Override
    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.workbench);
    }
}

