/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMRuntimeManager;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.IWsDOMRuntimeInfo;
import org.eclipse.jst.ws.jaxws.dom.runtime.registry.WsDOMRuntimeRegistry;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.TestWsDOMRuntimeExtension;

public class WsDOMRuntimeManagerTest
extends TestCase {
    private WsDOMRuntimeManager target;

    public void setUp() {
        this.target = (WsDOMRuntimeManager)WsDOMRuntimeManager.instance();
    }

    public void testGetDOMRuntimeForRuntimeInfo() {
        Collection registeredRuntimes = WsDOMRuntimeRegistry.getRegisteredRuntimesInfo();
        WsDOMRuntimeManagerTest.assertNotNull((Object)this.target.getDOMRuntime((IWsDOMRuntimeInfo)registeredRuntimes.iterator().next()));
        IWsDOMRuntimeExtension runtime = this.target.getDOMRuntime((IWsDOMRuntimeInfo)registeredRuntimes.iterator().next());
        WsDOMRuntimeManagerTest.assertEquals((Object)runtime, (Object)this.target.getDOMRuntime((IWsDOMRuntimeInfo)registeredRuntimes.iterator().next()));
        registeredRuntimes = WsDOMRuntimeRegistry.getRegisteredRuntimesInfo();
        WsDOMRuntimeManagerTest.assertEquals((Object)runtime, (Object)this.target.getDOMRuntime((IWsDOMRuntimeInfo)registeredRuntimes.iterator().next()));
    }

    public void testGetDOMRuntimeForRuntimeId() {
        WsDOMRuntimeManagerTest.assertNotNull((Object)this.target.getDOMRuntime("supportedruntimetest"));
        WsDOMRuntimeManagerTest.assertNull((Object)this.target.getDOMRuntime("test.id"));
        WsDOMRuntimeManagerTest.assertEquals((Object)this.target.getDOMRuntime("supportedruntimetest"), (Object)this.target.getDOMRuntime("supportedruntimetest"));
    }

    public void testCreateDOMRuntimes() {
        this.target.createDOMRuntimes(null);
        WsDOMRuntimeManagerTest.assertNotNull((Object)this.target.getDOMRuntime("supportedruntimetest"));
        WsDOMRuntimeManagerTest.assertNotNull((Object)this.target.getDOMRuntime("supportedruntimetest1"));
    }

    public void testReloadDOMRuntimes() {
        this.target.reloadDOMRuntimes(null);
        IWsDOMRuntimeExtension domRuntime = this.target.getDOMRuntime("supportedruntimetest");
        IWsDOMRuntimeExtension domRuntime1 = this.target.getDOMRuntime("supportedruntimetest1");
        this.target.reloadDOMRuntimes(null);
        WsDOMRuntimeManagerTest.assertNotSame((Object)domRuntime, (Object)this.target.getDOMRuntime(WsDOMRuntimeRegistry.getRuntimeInfo((String)"supportedruntimetest").getId()));
        WsDOMRuntimeManagerTest.assertNotSame((Object)domRuntime1, (Object)this.target.getDOMRuntime(WsDOMRuntimeRegistry.getRuntimeInfo((String)"supportedruntimetest1").getId()));
    }

    public void testGetDOMRuntimes() {
        IWsDOMRuntimeExtension domRuntime = this.target.getDOMRuntime("supportedruntimetest");
        WsDOMRuntimeManagerTest.assertNotNull((Object)domRuntime);
        WsDOMRuntimeManagerTest.assertTrue((boolean)(domRuntime instanceof TestWsDOMRuntimeExtension));
        IWsDOMRuntimeExtension domRuntime1 = this.target.getDOMRuntime("supportedruntimetest1");
        WsDOMRuntimeManagerTest.assertNotNull((Object)domRuntime1);
        WsDOMRuntimeManagerTest.assertTrue((boolean)(domRuntime1 instanceof TestWsDOMRuntimeExtension));
        IWsDOMRuntimeExtension domRuntime2 = this.target.getDOMRuntime("supportedruntimetest2");
        WsDOMRuntimeManagerTest.assertNull((Object)domRuntime2);
    }

    public void testCreateDOMPassesProgressMonitor() {
        MyWsDomRuntimeManager manager = new MyWsDomRuntimeManager();
        IWsDOMRuntimeInfo info = WsDOMRuntimeRegistry.getRuntimeInfo((String)"supportedruntimetest1");
        NullProgressMonitor npm = new NullProgressMonitor();
        IWsDOMRuntimeExtension rtEx = manager.createDOMRuntime(info, (IProgressMonitor)npm);
        WsDOMRuntimeManagerTest.assertTrue((boolean)(rtEx instanceof TestWsDOMRuntimeExtension));
        WsDOMRuntimeManagerTest.assertEquals((Object)npm, (Object)((TestWsDOMRuntimeExtension)rtEx).monitor);
    }

    private class MyWsDomRuntimeManager
    extends WsDOMRuntimeManager {
        private MyWsDomRuntimeManager() {
        }

        protected IWsDOMRuntimeExtension createDOMRuntime(IWsDOMRuntimeInfo runtimeInfo, IProgressMonitor monitor) {
            return super.createDOMRuntime(runtimeInfo, monitor);
        }
    }
}

