/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.model.event;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListEvent;

public final class ListReplaceEvent
extends ListEvent {
    private final int index;
    private final Object[] newItems;
    private final Object[] oldItems;
    private static final long serialVersionUID = 1L;

    public ListReplaceEvent(Model source, String listName, int index, Object newItem, Object oldItem) {
        this(source, listName, index, new Object[]{newItem}, new Object[]{oldItem});
    }

    public ListReplaceEvent(Model source, String listName, int index, List<?> newItems, List<?> oldItems) {
        this(source, listName, index, newItems.toArray(), oldItems.toArray());
    }

    private ListReplaceEvent(Model source, String listName, int index, Object[] newItems, Object[] oldItems) {
        super(source, listName);
        if (newItems.length != oldItems.length) {
            throw new IllegalArgumentException("sizes must match - new items size: " + newItems.length + " old items size: " + oldItems.length);
        }
        this.index = index;
        this.newItems = newItems;
        this.oldItems = oldItems;
    }

    public int getIndex() {
        return this.index;
    }

    public Iterable<?> getNewItems() {
        return IterableTools.iterable(this.newItems);
    }

    public Iterable<?> getOldItems() {
        return IterableTools.iterable(this.oldItems);
    }

    public int getItemsSize() {
        return this.newItems.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringBuilderTools.append(sb, this.oldItems);
        sb.append(" => ");
        StringBuilderTools.append(sb, this.newItems);
    }

    public ListReplaceEvent clone(Model newSource) {
        return this.clone(newSource, this.listName);
    }

    public ListReplaceEvent clone(Model newSource, String newListName) {
        return this.clone(newSource, newListName, 0);
    }

    public ListReplaceEvent clone(Model newSource, String newListName, int offset) {
        return new ListReplaceEvent(newSource, newListName, this.index + offset, this.newItems, this.oldItems);
    }
}

