/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesContextFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleFactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitFactoryType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteFactoryTestCase
extends BaseWriteTestCase {
    protected static final String FACTORY = "factory";
    private static final String APPLICATION_FACTORY = "application-factory";
    private static final String FACESCONTEXT_FACTORY = "faces-context-factory";
    private static final String LIFECYCLE_FACTORY = "lifecycle-factory";
    private static final String RENDERKIT_FACTORY = "render-kit-factory";
    private static final String FACTORY_ID = CommonStructuresUtil.createPreficedString("factory", "id");

    public WriteFactoryTestCase(String name) {
        super(name);
    }

    public void testFactory() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            FactoryType newfactory = facesConfigFactory.createFactoryType();
            ApplicationFactoryType newApplicationFactory = facesConfigFactory.createApplicationFactoryType();
            newApplicationFactory.setTextContent(APPLICATION_FACTORY);
            newApplicationFactory.setId(CommonStructuresUtil.createPreficedString(APPLICATION_FACTORY, "id"));
            newfactory.getApplicationFactory().add((Object)newApplicationFactory);
            FacesContextFactoryType facesContextFactory = facesConfigFactory.createFacesContextFactoryType();
            facesContextFactory.setTextContent(FACESCONTEXT_FACTORY);
            facesContextFactory.setId(CommonStructuresUtil.createPreficedString(FACESCONTEXT_FACTORY, "id"));
            newfactory.getFacesContextFactory().add((Object)facesContextFactory);
            LifecycleFactoryType lifecycleFactory = facesConfigFactory.createLifecycleFactoryType();
            lifecycleFactory.setTextContent(LIFECYCLE_FACTORY);
            lifecycleFactory.setId(CommonStructuresUtil.createPreficedString(LIFECYCLE_FACTORY, "id"));
            newfactory.getLifecycleFactory().add((Object)lifecycleFactory);
            RenderKitFactoryType renderKit = facesConfigFactory.createRenderKitFactoryType();
            renderKit.setTextContent(RENDERKIT_FACTORY);
            renderKit.setId(CommonStructuresUtil.createPreficedString(RENDERKIT_FACTORY, "id"));
            newfactory.getRenderKitFactory().add((Object)renderKit);
            newfactory.setId(FACTORY_ID);
            edit.getFacesConfig().getFactory().add((Object)newfactory);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteFactoryTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteFactoryTestCase.assertNotNull((Object)edit.getFacesConfig());
            FactoryType newFactory = (FactoryType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getFactory(), FACTORY_ID);
            WriteFactoryTestCase.assertNotNull((Object)newFactory);
            WriteFactoryTestCase.assertEquals((int)1, (int)newFactory.getApplicationFactory().size());
            ApplicationFactoryType newApplicationFactory = (ApplicationFactoryType)newFactory.getApplicationFactory().get(0);
            WriteFactoryTestCase.assertEquals((String)APPLICATION_FACTORY, (String)newApplicationFactory.getTextContent());
            WriteFactoryTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(APPLICATION_FACTORY, "id"), (String)newApplicationFactory.getId());
            WriteFactoryTestCase.assertEquals((int)1, (int)newFactory.getFacesContextFactory().size());
            FacesContextFactoryType facesContextFactory = (FacesContextFactoryType)newFactory.getFacesContextFactory().get(0);
            WriteFactoryTestCase.assertEquals((String)FACESCONTEXT_FACTORY, (String)facesContextFactory.getTextContent());
            WriteFactoryTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(FACESCONTEXT_FACTORY, "id"), (String)facesContextFactory.getId());
            WriteFactoryTestCase.assertEquals((int)1, (int)newFactory.getLifecycleFactory().size());
            LifecycleFactoryType lifecycleFactory = (LifecycleFactoryType)newFactory.getLifecycleFactory().get(0);
            WriteFactoryTestCase.assertEquals((String)LIFECYCLE_FACTORY, (String)lifecycleFactory.getTextContent());
            WriteFactoryTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(LIFECYCLE_FACTORY, "id"), (String)lifecycleFactory.getId());
            WriteFactoryTestCase.assertEquals((int)1, (int)newFactory.getRenderKitFactory().size());
            RenderKitFactoryType renderKit = (RenderKitFactoryType)newFactory.getRenderKitFactory().get(0);
            WriteFactoryTestCase.assertEquals((String)RENDERKIT_FACTORY, (String)renderKit.getTextContent());
            WriteFactoryTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDERKIT_FACTORY, "id"), (String)renderKit.getId());
            WriteFactoryTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(FACTORY, "id"), (String)newFactory.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

