/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.load;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.load.IWsDomCallback;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.load.WsDomObtainer;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.operation.IOperationRunner;
import org.jmock.core.Constraint;

public class WsDomObtainerTest
extends MockObjectTestCase {
    private static final String LOAD_CANCELLED_MSG = "Load_Cancelled";
    private IOperationRunner operationRunner;
    private WsDomObtainer domObtainer;
    private Mock<IWsDOMRuntimeExtension> domRuntime;
    private Mock<IDOM> dom;
    private Mock<IWsDomCallback> domCallback;
    private Mock<IExceptionHandler> excHandler;

    protected void setUp() throws Exception {
        super.setUp();
        this.setupOperationRunner();
        this.domRuntime = this.mock(IWsDOMRuntimeExtension.class);
        this.dom = this.mock(IDOM.class);
        this.domObtainer = new WsDomObtainer((IWsDOMRuntimeExtension)this.domRuntime.proxy(), this.operationRunner);
        this.domCallback = this.mock(IWsDomCallback.class);
    }

    private void setupOperationRunner() {
        this.excHandler = this.mock(IExceptionHandler.class);
        this.operationRunner = new IOperationRunner(){

            public void run(IRunnableWithProgress runnable) {
                try {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    ((IExceptionHandler)WsDomObtainerTest.this.excHandler.proxy()).handleException(e);
                }
                catch (InterruptedException e) {
                    ((IExceptionHandler)WsDomObtainerTest.this.excHandler.proxy()).handleException(e);
                }
            }
        };
    }

    public void testDomNotLoaded() {
        this.expectDomLoad();
        this.performLoad();
    }

    public void testDomAlreadyLoaded() {
        this.expectDomAlreadyLoaded();
        this.performLoad();
    }

    public void testCancelDomLoad() {
        this.expectCancelWhileLoading();
        this.performLoad();
    }

    public void testDomLoadPreviouslyCancelled() {
        this.expectLoadCancelledPreviously();
        this.performLoad();
    }

    public void testDomLoadFails() {
        this.expectLoadFails();
        this.performLoad();
    }

    public void testDomLoadedPriorLoadOperationStarts() {
        this.expectDomLoadedPriorLoadOperation();
        this.performLoad();
    }

    private void expectDomLoadedPriorLoadOperation() {
        this.domRuntime.expects(this.once()).method("getDOM").will(this.returnValue(null)).id("first_get");
        this.domRuntime.stubs().method("getDOM").after("first_get").will(this.returnValue(this.dom.proxy()));
        this.domCallback.expects(this.once()).method("dom").with((Constraint)this.same(this.dom.proxy()));
    }

    private void expectLoadFails() {
        IOException ioExc = new IOException("dom load failure");
        this.domRuntime.stubs().method("getDOM").will(this.returnValue(null));
        this.domRuntime.expects(this.once()).method("createDOM").with((Constraint)this.isA(IProgressMonitor.class)).after("getDOM").will(this.throwException(ioExc));
        this.domCallback.expects(this.once()).method("domLoadStarting").withNoArguments();
        this.domCallback.expects(this.once()).method("domLoadFailed").after("domLoadStarting");
        this.excHandler.expects(this.once()).method("handleException").with(this.invTargetExcMatcher(ioExc));
    }

    private Constraint invTargetExcMatcher(final Exception cause) {
        return new Constraint(){

            public StringBuffer describeTo(StringBuffer buffer) {
                buffer.append("unexpected exception");
                return buffer;
            }

            public boolean eval(Object o) {
                if (!(o instanceof InvocationTargetException)) {
                    return false;
                }
                InvocationTargetException invTargetE = (InvocationTargetException)o;
                return invTargetE.getCause() == cause;
            }
        };
    }

    private void expectLoadCancelledPreviously() {
        this.domRuntime.stubs().method("getDOM").will(this.throwException(this.loadCancelledExc())).id("first_getDOM");
        this.domRuntime.expects(this.once()).method("createDOM").with((Constraint)this.isA(IProgressMonitor.class)).after("first_getDOM").isVoid();
        this.domRuntime.stubs().method("getDOM").after("createDOM").will(this.returnValue(this.dom.proxy()));
        this.domCallback.expects(this.once()).method("domLoadStarting").withNoArguments();
        this.domCallback.expects(this.once()).method("dom").with((Constraint)this.same(this.dom.proxy())).after("domLoadStarting");
    }

    private void expectCancelWhileLoading() {
        this.domRuntime.stubs().method("getDOM").will(this.returnValue(null));
        this.domRuntime.expects(this.once()).method("createDOM").with((Constraint)this.isA(IProgressMonitor.class)).after("getDOM").will(this.throwException(this.loadCancelledExc()));
        this.domCallback.expects(this.once()).method("domLoadStarting").withNoArguments();
        this.domCallback.expects(this.once()).method("domLoadCancelled");
        this.excHandler.expects(this.once()).method("handleException").with((Constraint)this.isA(InterruptedException.class));
    }

    private void expectDomLoad() {
        this.domRuntime.stubs().method("getDOM").will(this.returnValue(null));
        this.domRuntime.expects(this.once()).method("createDOM").with((Constraint)this.isA(IProgressMonitor.class)).after("getDOM").isVoid();
        this.domRuntime.stubs().method("getDOM").after("createDOM").will(this.returnValue(this.dom.proxy()));
        this.domCallback.expects(this.once()).method("domLoadStarting").withNoArguments();
        this.domCallback.expects(this.once()).method("dom").with((Constraint)this.same(this.dom.proxy())).after("domLoadStarting");
    }

    private void expectDomAlreadyLoaded() {
        this.domRuntime.stubs().method("getDOM").will(this.returnValue(this.dom.proxy()));
        this.domCallback.expects(this.once()).method("dom").with((Constraint)this.same(this.dom.proxy()));
    }

    private void performLoad() {
        this.domObtainer.getDom((IWsDomCallback)this.domCallback.proxy());
    }

    private WsDOMLoadCanceledException loadCancelledExc() {
        return new WsDOMLoadCanceledException(LOAD_CANCELLED_MSG, LOAD_CANCELLED_MSG);
    }

    private static interface IExceptionHandler {
        public void handleException(Exception var1);
    }
}

