/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public final class CheckEmptyStatements
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType USELESS_EMPTY_STATEMENT = DiagnosticType.warning("JSC_USELESS_EMPTY_STATEMENT", "Useless empty statement. Remove semicolon.");
    private final AbstractCompiler compiler;

    public CheckEmptyStatements(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isEmpty() && NodeUtil.isStatement(n)) {
            t.report(n, USELESS_EMPTY_STATEMENT, new String[0]);
        }
    }
}

