/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;

public class ServletDataModelSyncHelper
extends DataModelSynchHelper {
    protected Map widgetToValueHash;
    protected MultipleCheckboxSelectionListener multipleCheckboxSelectionListener;

    public ServletDataModelSyncHelper(IDataModel model) {
        super(model);
    }

    public void synchUIWithModel(final String propertyName, final int flag) {
        if (this.propertyToWidgetHash != null && this.propertyToWidgetHash.containsKey(propertyName)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        Object obj = ServletDataModelSyncHelper.this.propertyToWidgetHash.get(propertyName);
                        if (obj != null) {
                            if (obj instanceof List) {
                                List widgets = (List)obj;
                                int i = 0;
                                while (i < widgets.size()) {
                                    ServletDataModelSyncHelper.this.currentWidget = (Widget)widgets.get(i);
                                    ServletDataModelSyncHelper.this.synchUIWithModel(propertyName, flag, ServletDataModelSyncHelper.this.currentWidget);
                                    ++i;
                                }
                            } else {
                                ServletDataModelSyncHelper.this.currentWidget = (Widget)obj;
                                ServletDataModelSyncHelper.this.synchUIWithModel(propertyName, flag, ServletDataModelSyncHelper.this.currentWidget);
                            }
                        }
                    }
                    finally {
                        ServletDataModelSyncHelper.this.currentWidget = null;
                    }
                }
            });
        }
    }

    protected void synchUIWithModel(String propertyName, int flag, Widget currentWidget) {
        if (currentWidget != null && currentWidget != this.currentWidgetFromEvent) {
            Widget widget = currentWidget;
            try {
                this.ignoreModifyEvent = true;
                if (currentWidget instanceof Text) {
                    this.setWidgetValue(propertyName, flag, (Text)currentWidget);
                } else if (currentWidget instanceof Combo) {
                    this.setWidgetValue(propertyName, flag, (Combo)currentWidget);
                } else if (currentWidget instanceof Button) {
                    this.setWidgetValue(propertyName, flag, (Button)currentWidget);
                } else if (currentWidget instanceof Label) {
                    this.setWidgetValue(propertyName, flag, (Label)currentWidget);
                } else if (currentWidget instanceof List) {
                    this.setWidgetValue(propertyName, flag, (org.eclipse.swt.widgets.List)currentWidget);
                } else if (currentWidget instanceof Table) {
                    this.setWidgetValue(propertyName, flag, (Table)currentWidget);
                } else if (currentWidget instanceof Tree) {
                    this.setWidgetValue(propertyName, flag, (Tree)currentWidget);
                }
            }
            finally {
                this.ignoreModifyEvent = false;
            }
            this.setEnablement((Control)widget, this.dataModel.isPropertyEnabled(propertyName));
        }
    }

    protected void setWidgetValue(String propertyName, int flag, Button button) {
        Object propertyValue;
        if ((button.getStyle() & 0x20) == 32 && (propertyValue = this.dataModel.getProperty(propertyName)) instanceof List) {
            List value = (List)propertyValue;
            Object buttonValue = this.widgetToValueHash.get(button);
            boolean exists = value.contains(buttonValue);
            if (button.getSelection() != exists) {
                button.setSelection(exists);
            }
            return;
        }
    }

    public void synchCheckbox(Button checkbox, String textValue, String propertyName, Control[] dependentControls) {
        this.setCompositeValue((Widget)checkbox, textValue);
        this.synchComposite((Widget)checkbox, propertyName, dependentControls);
        if (this.multipleCheckboxSelectionListener == null) {
            this.multipleCheckboxSelectionListener = new MultipleCheckboxSelectionListener();
        }
        checkbox.addSelectionListener((SelectionListener)this.multipleCheckboxSelectionListener);
    }

    protected void setCompositeValue(Widget widget, Object value) {
        if (this.widgetToValueHash == null) {
            this.widgetToValueHash = new HashMap();
        }
        this.widgetToValueHash.put(widget, value);
    }

    protected void synchComposite(Widget widget, String propertyName, Control[] depControls) {
        if (this.widgetToPropertyHash == null) {
            this.widgetToPropertyHash = new HashMap();
        }
        if (this.propertyToWidgetHash == null) {
            this.propertyToWidgetHash = new HashMap();
        }
        this.widgetToPropertyHash.put(widget, propertyName);
        Object value = this.propertyToWidgetHash.get(propertyName);
        List widgets = value == null || !(value instanceof List) ? new ArrayList() : (List)value;
        widgets.add(widget);
        this.propertyToWidgetHash.put(propertyName, widgets);
        if (depControls != null) {
            if (this.widgetToDepControls == null) {
                this.widgetToDepControls = new HashMap();
            }
            this.widgetToDepControls.put(widget, depControls);
        }
        this.synchUIWithModel(propertyName, 1);
    }

    private class MultipleCheckboxSelectionListener
    implements SelectionListener {
        private MultipleCheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            if (ServletDataModelSyncHelper.this.currentWidget == button) {
                return;
            }
            try {
                ServletDataModelSyncHelper.this.currentWidgetFromEvent = (Widget)button;
                String propertyName = (String)ServletDataModelSyncHelper.this.widgetToPropertyHash.get(button);
                Object propertyValue = ServletDataModelSyncHelper.this.widgetToValueHash.get(button);
                ArrayList contents = ServletDataModelSyncHelper.this.dataModel.getProperty(propertyName);
                if (contents == null) {
                    contents = new ArrayList();
                }
                if (contents instanceof List) {
                    List list = contents;
                    if (button.getSelection()) {
                        if (!list.contains(propertyValue)) {
                            list.add(propertyValue);
                        }
                    } else {
                        list.remove(propertyValue);
                    }
                    ServletDataModelSyncHelper.this.setProperty(propertyName, list);
                    ServletDataModelSyncHelper.this.dataModel.notifyPropertyChange(propertyName, 1);
                }
            }
            finally {
                ServletDataModelSyncHelper.this.currentWidgetFromEvent = null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

