/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporalAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyTemporal2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public MapKeyTemporal2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTemporal() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKeyTemporal"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyTemporal");
            }
        });
    }

    private ICompilationUnit createTestTemporalWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKeyTemporal", "javax.persistence.TemporalType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyTemporal(TemporalType.DATE)");
            }
        });
    }

    public void testTemporal() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyTemporalAnnotation2_0 temporal = (MapKeyTemporalAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        MapKeyTemporal2_0AnnotationTests.assertNotNull((Object)temporal);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporalWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyTemporalAnnotation2_0 temporal = (MapKeyTemporalAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        MapKeyTemporal2_0AnnotationTests.assertEquals((Object)TemporalType.DATE, (Object)temporal.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestTemporal();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyTemporalAnnotation2_0 temporal = (MapKeyTemporalAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.assertSourceContains("@MapKeyTemporal(TIME)", cu);
        temporal.setValue(null);
        this.assertSourceDoesNotContain("@MapKeyTemporal(", cu);
    }
}

