/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlElementMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlPathTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlPathTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPath");
            }
        });
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlPath();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlPath xpath = mapping.getXmlPath();
        XmlPathAnnotation annotation = (XmlPathAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        ELJavaXmlPathTests.assertNull((Object)annotation.getValue());
        ELJavaXmlPathTests.assertNull((Object)xpath.getValue());
        xpath.setValue("foo");
        ELJavaXmlPathTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlPathTests.assertEquals((String)"foo", (String)xpath.getValue());
        xpath.setValue("");
        ELJavaXmlPathTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlPathTests.assertEquals((String)"", (String)xpath.getValue());
        xpath.setValue(null);
        ELJavaXmlPathTests.assertNull((Object)annotation.getValue());
        ELJavaXmlPathTests.assertNull((Object)xpath.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlPath();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlElementMapping mapping = (ELJavaXmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELXmlPath xpath = mapping.getXmlPath();
        XmlPathAnnotation annotation = (XmlPathAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        ELJavaXmlPathTests.assertNull((Object)annotation.getValue());
        ELJavaXmlPathTests.assertNull((Object)xpath.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlPathTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "foo");
            }
        });
        ELJavaXmlPathTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlPathTests.assertEquals((String)"foo", (String)xpath.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlPathTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "");
            }
        });
        ELJavaXmlPathTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlPathTests.assertEquals((String)"", (String)xpath.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlPathTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlPathTests.assertNull((Object)annotation.getValue());
        ELJavaXmlPathTests.assertNull((Object)xpath.getValue());
    }
}

