/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkPersistenceUnitDefaultsTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkPersistenceUnitDefaultsTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/eclipselink-orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    protected OrmPersistenceUnitDefaults persistenceUnitDefaults() {
        return this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
    }

    public void testIsAllFeaturesUnset() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlPersistenceUnitMetadata persistenceUnitMetadata = EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)persistenceUnitMetadata);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitMetadata.isUnset());
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlPersistenceUnitDefaults persistenceUnitDefaultsResource = EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        persistenceUnitMetadata.setPersistenceUnitDefaults((XmlPersistenceUnitDefaults)persistenceUnitDefaultsResource);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCascadePersist(true);
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCascadePersist(false);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setSchema("asdf");
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setSchema(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCatalog("asdf");
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setCatalog(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess("PROPERTY");
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess("FIELD");
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaultsResource.isUnset());
        persistenceUnitDefaultsResource.setAccess(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaultsResource.isUnset());
    }

    public void testUpdateSchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults((XmlPersistenceUnitDefaults)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifySchema2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setSpecifiedSchema(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testModifySchema3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedSchema("MY_SCHEMA");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_SCHEMA", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSpecifiedSchema(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSchema());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults((XmlPersistenceUnitDefaults)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCatalog2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSchema("MY_SCHEMA");
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testModifyCatalog3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedCatalog("MY_CATALOG");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"MY_CATALOG", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setSpecifiedCatalog(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getCatalog());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults((XmlPersistenceUnitDefaults)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(false);
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyCascadePersist2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setCascadePersist(true);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCatalog("MY_CATALOG");
        persistenceUnitDefaults.setCascadePersist(false);
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
    }

    public void testModifyCascadePersist3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setCascadePersist(true);
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertTrue((boolean)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().isCascadePersist());
        persistenceUnitDefaults.setCascadePersist(false);
        EclipseLinkPersistenceUnitDefaultsTests.assertFalse((boolean)persistenceUnitDefaults.isCascadePersist());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }

    public void testUpdateAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults((XmlPersistenceUnitDefaults)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess("FIELD");
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"FIELD", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedAccess(AccessType.PROPERTY);
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"PROPERTY", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setSpecifiedAccess(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
    }

    public void testModifyAccess2() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        persistenceUnitDefaults.setSpecifiedAccess(AccessType.FIELD);
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"FIELD", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setCascadePersist(true);
        persistenceUnitDefaults.setSpecifiedAccess(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
    }

    public void testModifyAccess3() throws Exception {
        OrmPersistenceUnitDefaults persistenceUnitDefaults = this.persistenceUnitDefaults();
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata());
        this.getXmlEntityMappings().setPersistenceUnitMetadata((XmlPersistenceUnitMetadata)EclipseLinkOrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        this.getXmlEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        persistenceUnitDefaults.setSpecifiedAccess(AccessType.FIELD);
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((Object)AccessType.FIELD, (Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertEquals((String)"FIELD", (String)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getAccess());
        persistenceUnitDefaults.setSpecifiedAccess(null);
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)persistenceUnitDefaults.getSpecifiedAccess());
        EclipseLinkPersistenceUnitDefaultsTests.assertNull((Object)this.getXmlEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults());
    }
}

