/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.math.BigInteger;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SimpleAtomicItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class RangeResultSequence
extends ResultSequence {
    private int _start;
    private int _end;
    private int _size;
    private ResultSequence _tail;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.RangeResultSequence");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RangeResultSequence(int start, int end) {
        this._size = end - start + 1;
        if (!$assertionsDisabled && this._size < 0) {
            throw new AssertionError();
        }
        this._start = start;
        this._end = end;
        this._tail = ResultSequenceFactory.create_new();
    }

    public void add(AnyType item) {
        this._tail.add(item);
    }

    public void concat(ResultSequence rs) {
        this._tail.concat(rs);
    }

    public ListIterator iterator() {
        if (this._size != 0) {
            ResultSequence newtail = ResultSequenceFactory.create_new();
            while (this._start <= this._end) {
                newtail.add(new XSInteger(BigInteger.valueOf(this._start)));
                ++this._start;
            }
            newtail.concat(this._tail);
            this._tail.release();
            this._tail = newtail;
            this._size = 0;
            this._start = 0;
            this._end = 0;
        }
        return this._tail.iterator();
    }

    public AnyType get(int i) {
        if (i < this._size) {
            return new XSInteger(BigInteger.valueOf(this._start + i));
        }
        return this._tail.get(i - this._size);
    }

    public int size() {
        return this._size + this._tail.size();
    }

    public void clear() {
        this._size = 0;
        this._tail.clear();
    }

    public ResultSequence create_new() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public AnyType first() {
        return this.get(0);
    }

    public Object firstValue() {
        return this.get(0).getNativeValue();
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public ItemType sequenceType() {
        return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_INTEGER, 2);
    }

    public void release() {
    }
}

