/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.internal.format.CompoundRegion;
import org.eclipse.wst.json.core.internal.format.DefaultJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.FormatRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class UnknownRuleFormatter
extends DefaultJSONSourceFormatter {
    private static UnknownRuleFormatter instance;

    UnknownRuleFormatter() {
    }

    @Override
    protected void formatPre(IJSONNode node, StringBuilder source) {
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        int start = node.getStartOffset();
        int end = node.getEndOffset();
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedPropValueRegion(regions[i], stgy));
                ++i;
            }
        }
    }

    @Override
    protected void formatPre(IJSONNode node, IRegion region, StringBuilder source) {
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || UnknownRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropValueRegion(regions[i], stgy));
            ++i;
        }
        if (UnknownRuleFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    public static synchronized UnknownRuleFormatter getInstance() {
        if (instance == null) {
            instance = new UnknownRuleFormatter();
        }
        return instance;
    }
}

