/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaJoinTableTests
extends ContextModelTestCase {
    public JavaJoinTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("    private Collection<Project> projects;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    private void createTargetEntityWithBackPointer() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append("    @ManyToMany(mappedBy=\"projects\"").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        resourceField.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        javaJoinTable.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getName());
        javaJoinTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedName("foo");
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getName());
        joinTable.setSpecifiedName(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        this.createTargetEntity();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaJoinTableTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getResolvedTargetEntity().getTable().setSpecifiedName("FOO");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)joinTable.getDefaultName());
        this.getJavaEntity().getTable().setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR_FOO", (String)joinTable.getDefaultName());
    }

    public void testDefaultJoinColumns() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next();
        SpecifiedJoinColumn inverseJoinColumn = (SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntity();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        this.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_id", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testDefaultJoinColumnsBidirectionalRelationship() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next();
        SpecifiedJoinColumn inverseJoinColumn = (SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntityWithBackPointer();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        this.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        JavaJoinTableTests.assertEquals((String)"employees_id", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        resourceField.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        javaJoinTable.setSchema(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getSchema());
        javaJoinTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedSchema("foo");
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getSchema());
        joinTable.setSpecifiedSchema(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        resourceField.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedCatalog("foo");
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getCatalog());
        joinTable.setSpecifiedCatalog(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getCatalog());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn joinColumn = joinTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(0).getName());
        JavaSpecifiedJoinColumn joinColumn2 = joinTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(1).getName());
        JavaSpecifiedJoinColumn joinColumn3 = joinTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        ListIterator joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.getJoinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableAnnotation.getJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableAnnotation.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableAnnotation.joinColumnAt(1).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableAnnotation.getJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableAnnotation.joinColumnAt(0).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableAnnotation.getJoinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumnsSize());
        joinTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        joinTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.addAnnotation("javax.persistence.JoinTable");
        joinTableResource.addJoinColumn(0);
        joinTableResource.addJoinColumn(1);
        joinTableResource.addJoinColumn(2);
        joinTableResource.joinColumnAt(0).setName("FOO");
        joinTableResource.joinColumnAt(1).setName("BAR");
        joinTableResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.getSpecifiedJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertFalse((boolean)joinTable.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.getSpecifiedJoinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getSpecifiedJoinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.getSpecifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.getJoinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        JavaJoinTableTests.assertNotNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
        JavaResourceAttribute resAttribute = ((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getResourceAttribute();
        JavaJoinTableTests.assertNotNull((Object)resAttribute.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getRelationship().getJoinTableStrategy().removeStrategy();
        JavaJoinTableTests.assertNotNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
        JavaJoinTableTests.assertNull((Object)resAttribute.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("foo");
        JavaJoinTableTests.assertNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
    }

    public void testAddSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaSpecifiedJoinColumn inverseJoinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaSpecifiedJoinColumn inverseJoinColumn2 = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaSpecifiedJoinColumn inverseJoinColumn3 = joinTable.addSpecifiedInverseJoinColumn(1);
        inverseJoinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        ListIterator inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn2, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn3, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn, inverseJoinColumns.next());
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
    }

    public void testRemoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableResource.getInverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableResource.getInverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableResource.getInverseJoinColumnsSize());
    }

    public void testMoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumnsSize());
        joinTable.moveSpecifiedInverseJoinColumn(2, 0);
        ListIterator inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        joinTable.moveSpecifiedInverseJoinColumn(0, 1);
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
    }

    public void testUpdateInverseJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)resourceField.addAnnotation("javax.persistence.JoinTable");
        joinTableResource.addInverseJoinColumn(0);
        joinTableResource.addInverseJoinColumn(1);
        joinTableResource.addInverseJoinColumn(2);
        joinTableResource.inverseJoinColumnAt(0).setName("FOO");
        joinTableResource.inverseJoinColumnAt(1).setName("BAR");
        joinTableResource.inverseJoinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.getSpecifiedInverseJoinColumns().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertFalse((boolean)joinTable.getSpecifiedInverseJoinColumns().iterator().hasNext());
    }

    public void testGetDefaultInverseJoinColumn() {
    }

    public void testSpecifiedInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.getSpecifiedInverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getSpecifiedInverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.getSpecifiedInverseJoinColumnsSize());
    }

    public void testInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.getInverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        manyToManyMapping.getRelationship().setStrategyToMappedBy();
        JavaJoinTableTests.assertNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ListIterator uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaJoinTableTests.assertEquals((String)"bar", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"foo", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.getUniqueConstraintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.getUniqueConstraintsSize());
        joinTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.getUniqueConstraintsSize());
        joinTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        joinTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceField.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        joinTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.getUniqueConstraints().iterator();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

