/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorValueAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaClassMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaClassMappingTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    public void testModifyXmlDiscriminatorNode() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlDiscriminatorNodeAnnotation annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNull((Object)annotation);
        classMapping.addXmlDiscriminatorNode();
        annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNotNull((Object)annotation);
        classMapping.removeXmlDiscriminatorNode();
        annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlDiscriminatorNode() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlDiscriminatorNodeAnnotation annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
            }
        });
        annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaClassMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
            }
        });
        annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorNode());
        ELJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testModifyXmlDiscriminatorValue() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlDiscriminatorValueAnnotation annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNull((Object)annotation);
        classMapping.addXmlDiscriminatorValue();
        annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNotNull((Object)annotation);
        classMapping.removeXmlDiscriminatorValue();
        annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlDiscriminatorValue() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlDiscriminatorValueAnnotation annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
            }
        });
        annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaClassMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
            }
        });
        annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaClassMappingTests.assertNull((Object)classMapping.getXmlDiscriminatorValue());
        ELJavaClassMappingTests.assertNull((Object)annotation);
    }
}

